/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.aop;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.IntroductionInterceptor;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.support.IntroductionInfoSupport;

public class DelegateFactoryIntroductionInterceptor
extends IntroductionInfoSupport
implements IntroductionInterceptor {
    private DelegateFactory delegateFactory;
    private Class<?> interfaceType;
    private final Map<Object, Object> delegateMap = new WeakHashMap<Object, Object>();

    public DelegateFactoryIntroductionInterceptor(DelegateFactory delegateFactory, Class<?> interfaceType) {
        this.delegateFactory = delegateFactory;
        this.interfaceType = interfaceType;
        this.publishedInterfaces.add(interfaceType);
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        if (this.isMethodOnIntroducedInterface(mi)) {
            Object delegate = this.getIntroductionDelegateFor(mi.getThis());
            Object retVal = AopUtils.invokeJoinpointUsingReflection((Object)delegate, (Method)mi.getMethod(), (Object[])mi.getArguments());
            if (retVal == delegate && mi instanceof ProxyMethodInvocation) {
                retVal = ((ProxyMethodInvocation)mi).getProxy();
            }
            return retVal;
        }
        return this.doProceed(mi);
    }

    protected Object doProceed(MethodInvocation mi) throws Throwable {
        return mi.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getIntroductionDelegateFor(Object targetObject) {
        Map<Object, Object> map = this.delegateMap;
        synchronized (map) {
            if (this.delegateMap.containsKey(targetObject)) {
                return this.delegateMap.get(targetObject);
            }
            Object delegate = this.createNewDelegate(targetObject);
            this.delegateMap.put(targetObject, delegate);
            return delegate;
        }
    }

    protected Object createNewDelegate(Object targetObject) {
        try {
            return this.delegateFactory.createNewDelegate(targetObject);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cant create delegate instance of type [" + this.interfaceType.getName() + "] : " + e.getMessage());
        }
    }

    public static interface DelegateFactory {
        public Object createNewDelegate(Object var1) throws Exception;
    }
}

