/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.aop;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.aop.SerializableObject;
import org.springframework.util.ObjectUtils;

public class DefaultSerializableObject
implements SerializableObject {
    private static final Log log = LogFactory.getLog(DefaultSerializableObject.class);
    private static final Map<String, Object> serializedObjects = new ConcurrentHashMap<String, Object>();
    private Object serializedObject;

    public DefaultSerializableObject() {
    }

    public DefaultSerializableObject(Object serializedObject) {
        this.serializedObject = serializedObject;
    }

    @Override
    public Object writeReplace() throws ObjectStreamException {
        return new SerializedReference(this.serializedObject);
    }

    public Object getSerializedObject() {
        return this.serializedObject;
    }

    public void setSerializedObject(Object serializedObject) {
        this.serializedObject = serializedObject;
    }

    private static class SerializedReference
    implements Serializable {
        private final String id;

        public SerializedReference(Object obj) {
            this.id = ObjectUtils.identityToString((Object)obj);
            serializedObjects.put(this.id, obj);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added new serialized reference. serialized objects size [" + serializedObjects.size() + "]"));
            }
        }

        private Object readResolve() {
            Object ret = serializedObjects.remove(this.id);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed a serialized reference. serialized objects size [" + serializedObjects.size() + "]"));
            }
            return ret;
        }
    }
}

