/*
 * Decompiled with CFR 0.152.
 */
package jcuda.vec;

import jcuda.CudaException;
import jcuda.Pointer;
import jcuda.vec.DefaultVecKernels;
import jcuda.vec.VecKernels;

public class VecFloat {
    private static VecKernels vecKernels = null;

    private VecFloat() {
    }

    public static void init() {
        String kernelNamePrefix = "vec_";
        String kernelNameType = "float";
        String kernelNameSuffix = "f";
        vecKernels = new DefaultVecKernels(kernelNameType, kernelNamePrefix, kernelNameSuffix);
    }

    public static void shutdown() {
        if (vecKernels != null) {
            vecKernels.shutdown();
            vecKernels = null;
        }
    }

    private static void call(String name, long workSize, Object ... arguments) {
        if (vecKernels == null) {
            throw new CudaException("Kernels not initialized. Call init() first.");
        }
        vecKernels.call(name, workSize, arguments);
    }

    public static void set(long n, Pointer result, float value) {
        VecFloat.call("set", n, n, result, Float.valueOf(value));
    }

    public static void add(long n, Pointer result, Pointer x, Pointer y) {
        VecFloat.call("add", n, n, result, x, y);
    }

    public static void sub(long n, Pointer result, Pointer x, Pointer y) {
        VecFloat.call("sub", n, n, result, x, y);
    }

    public static void mul(long n, Pointer result, Pointer x, Pointer y) {
        VecFloat.call("mul", n, n, result, x, y);
    }

    public static void div(long n, Pointer result, Pointer x, Pointer y) {
        VecFloat.call("div", n, n, result, x, y);
    }

    public static void negate(long n, Pointer result, Pointer x) {
        VecFloat.call("negate", n, n, result, x);
    }

    public static void addScalar(long n, Pointer result, Pointer x, float y) {
        VecFloat.call("addScalar", n, n, result, x, Float.valueOf(y));
    }

    public static void subScalar(long n, Pointer result, Pointer x, float y) {
        VecFloat.call("subScalar", n, n, result, x, Float.valueOf(y));
    }

    public static void mulScalar(long n, Pointer result, Pointer x, float y) {
        VecFloat.call("mulScalar", n, n, result, x, Float.valueOf(y));
    }

    public static void divScalar(long n, Pointer result, Pointer x, float y) {
        VecFloat.call("divScalar", n, n, result, x, Float.valueOf(y));
    }

    public static void scalarAdd(long n, Pointer result, float x, Pointer y) {
        VecFloat.call("scalarAdd", n, n, result, Float.valueOf(x), y);
    }

    public static void scalarSub(long n, Pointer result, float x, Pointer y) {
        VecFloat.call("scalarSub", n, n, result, Float.valueOf(x), y);
    }

    public static void scalarMul(long n, Pointer result, float x, Pointer y) {
        VecFloat.call("scalarMul", n, n, result, Float.valueOf(x), y);
    }

    public static void scalarDiv(long n, Pointer result, float x, Pointer y) {
        VecFloat.call("scalarDiv", n, n, result, Float.valueOf(x), y);
    }

    public static void lt(long n, Pointer result, Pointer x, Pointer y) {
        VecFloat.call("lt", n, n, result, x, y);
    }

    public static void lte(long n, Pointer result, Pointer x, Pointer y) {
        VecFloat.call("lte", n, n, result, x, y);
    }

    public static void eq(long n, Pointer result, Pointer x, Pointer y) {
        VecFloat.call("eq", n, n, result, x, y);
    }

    public static void gte(long n, Pointer result, Pointer x, Pointer y) {
        VecFloat.call("gte", n, n, result, x, y);
    }

    public static void gt(long n, Pointer result, Pointer x, Pointer y) {
        VecFloat.call("gt", n, n, result, x, y);
    }

    public static void ne(long n, Pointer result, Pointer x, Pointer y) {
        VecFloat.call("ne", n, n, result, x, y);
    }

    public static void ltScalar(long n, Pointer result, Pointer x, float y) {
        VecFloat.call("ltScalar", n, n, result, x, Float.valueOf(y));
    }

    public static void lteScalar(long n, Pointer result, Pointer x, float y) {
        VecFloat.call("lteScalar", n, n, result, x, Float.valueOf(y));
    }

    public static void eqScalar(long n, Pointer result, Pointer x, float y) {
        VecFloat.call("eqScalar", n, n, result, x, Float.valueOf(y));
    }

    public static void gteScalar(long n, Pointer result, Pointer x, float y) {
        VecFloat.call("gteScalar", n, n, result, x, Float.valueOf(y));
    }

    public static void gtScalar(long n, Pointer result, Pointer x, float y) {
        VecFloat.call("gtScalar", n, n, result, x, Float.valueOf(y));
    }

    public static void neScalar(long n, Pointer result, Pointer x, float y) {
        VecFloat.call("neScalar", n, n, result, x, Float.valueOf(y));
    }

    public static void acos(long n, Pointer result, Pointer x) {
        VecFloat.call("acos", n, n, result, x);
    }

    public static void acosh(long n, Pointer result, Pointer x) {
        VecFloat.call("acosh", n, n, result, x);
    }

    public static void asin(long n, Pointer result, Pointer x) {
        VecFloat.call("asin", n, n, result, x);
    }

    public static void asinh(long n, Pointer result, Pointer x) {
        VecFloat.call("asinh", n, n, result, x);
    }

    public static void atan(long n, Pointer result, Pointer x) {
        VecFloat.call("atan", n, n, result, x);
    }

    public static void atanh(long n, Pointer result, Pointer x) {
        VecFloat.call("atanh", n, n, result, x);
    }

    public static void cbrt(long n, Pointer result, Pointer x) {
        VecFloat.call("cbrt", n, n, result, x);
    }

    public static void ceil(long n, Pointer result, Pointer x) {
        VecFloat.call("ceil", n, n, result, x);
    }

    public static void cos(long n, Pointer result, Pointer x) {
        VecFloat.call("cos", n, n, result, x);
    }

    public static void cosh(long n, Pointer result, Pointer x) {
        VecFloat.call("cosh", n, n, result, x);
    }

    public static void cospi(long n, Pointer result, Pointer x) {
        VecFloat.call("cospi", n, n, result, x);
    }

    public static void erfc(long n, Pointer result, Pointer x) {
        VecFloat.call("erfc", n, n, result, x);
    }

    public static void erfcinv(long n, Pointer result, Pointer x) {
        VecFloat.call("erfcinv", n, n, result, x);
    }

    public static void erfcx(long n, Pointer result, Pointer x) {
        VecFloat.call("erfcx", n, n, result, x);
    }

    public static void erf(long n, Pointer result, Pointer x) {
        VecFloat.call("erf", n, n, result, x);
    }

    public static void erfinv(long n, Pointer result, Pointer x) {
        VecFloat.call("erfinv", n, n, result, x);
    }

    public static void exp10(long n, Pointer result, Pointer x) {
        VecFloat.call("exp10", n, n, result, x);
    }

    public static void exp2(long n, Pointer result, Pointer x) {
        VecFloat.call("exp2", n, n, result, x);
    }

    public static void exp(long n, Pointer result, Pointer x) {
        VecFloat.call("exp", n, n, result, x);
    }

    public static void expm1(long n, Pointer result, Pointer x) {
        VecFloat.call("expm1", n, n, result, x);
    }

    public static void fabs(long n, Pointer result, Pointer x) {
        VecFloat.call("fabs", n, n, result, x);
    }

    public static void floor(long n, Pointer result, Pointer x) {
        VecFloat.call("floor", n, n, result, x);
    }

    public static void j0(long n, Pointer result, Pointer x) {
        VecFloat.call("j0", n, n, result, x);
    }

    public static void j1(long n, Pointer result, Pointer x) {
        VecFloat.call("j1", n, n, result, x);
    }

    public static void lgamma(long n, Pointer result, Pointer x) {
        VecFloat.call("lgamma", n, n, result, x);
    }

    public static void log10(long n, Pointer result, Pointer x) {
        VecFloat.call("log10", n, n, result, x);
    }

    public static void log1p(long n, Pointer result, Pointer x) {
        VecFloat.call("log1p", n, n, result, x);
    }

    public static void log2(long n, Pointer result, Pointer x) {
        VecFloat.call("log2", n, n, result, x);
    }

    public static void logb(long n, Pointer result, Pointer x) {
        VecFloat.call("logb", n, n, result, x);
    }

    public static void log(long n, Pointer result, Pointer x) {
        VecFloat.call("log", n, n, result, x);
    }

    public static void normcdf(long n, Pointer result, Pointer x) {
        VecFloat.call("normcdf", n, n, result, x);
    }

    public static void normcdfinv(long n, Pointer result, Pointer x) {
        VecFloat.call("normcdfinv", n, n, result, x);
    }

    public static void rcbrt(long n, Pointer result, Pointer x) {
        VecFloat.call("rcbrt", n, n, result, x);
    }

    public static void rint(long n, Pointer result, Pointer x) {
        VecFloat.call("rint", n, n, result, x);
    }

    public static void round(long n, Pointer result, Pointer x) {
        VecFloat.call("round", n, n, result, x);
    }

    public static void rsqrt(long n, Pointer result, Pointer x) {
        VecFloat.call("rsqrt", n, n, result, x);
    }

    public static void sin(long n, Pointer result, Pointer x) {
        VecFloat.call("sin", n, n, result, x);
    }

    public static void sinh(long n, Pointer result, Pointer x) {
        VecFloat.call("sinh", n, n, result, x);
    }

    public static void sinpi(long n, Pointer result, Pointer x) {
        VecFloat.call("sinpi", n, n, result, x);
    }

    public static void sqrt(long n, Pointer result, Pointer x) {
        VecFloat.call("sqrt", n, n, result, x);
    }

    public static void tan(long n, Pointer result, Pointer x) {
        VecFloat.call("tan", n, n, result, x);
    }

    public static void tanh(long n, Pointer result, Pointer x) {
        VecFloat.call("tanh", n, n, result, x);
    }

    public static void tgamma(long n, Pointer result, Pointer x) {
        VecFloat.call("tgamma", n, n, result, x);
    }

    public static void trunc(long n, Pointer result, Pointer x) {
        VecFloat.call("trunc", n, n, result, x);
    }

    public static void y0(long n, Pointer result, Pointer x) {
        VecFloat.call("y0", n, n, result, x);
    }

    public static void y1(long n, Pointer result, Pointer x) {
        VecFloat.call("y1", n, n, result, x);
    }

    public static void copysign(long n, Pointer result, Pointer x, Pointer y) {
        VecFloat.call("copysign", n, n, result, x, y);
    }

    public static void fdim(long n, Pointer result, Pointer x, Pointer y) {
        VecFloat.call("fdim", n, n, result, x, y);
    }

    public static void fdivide(long n, Pointer result, Pointer x, Pointer y) {
        VecFloat.call("fdivide", n, n, result, x, y);
    }

    public static void fmax(long n, Pointer result, Pointer x, Pointer y) {
        VecFloat.call("fmax", n, n, result, x, y);
    }

    public static void fmin(long n, Pointer result, Pointer x, Pointer y) {
        VecFloat.call("fmin", n, n, result, x, y);
    }

    public static void fmod(long n, Pointer result, Pointer x, Pointer y) {
        VecFloat.call("fmod", n, n, result, x, y);
    }

    public static void hypot(long n, Pointer result, Pointer x, Pointer y) {
        VecFloat.call("hypot", n, n, result, x, y);
    }

    public static void nextafter(long n, Pointer result, Pointer x, Pointer y) {
        VecFloat.call("nextafter", n, n, result, x, y);
    }

    public static void pow(long n, Pointer result, Pointer x, Pointer y) {
        VecFloat.call("pow", n, n, result, x, y);
    }

    public static void remainder(long n, Pointer result, Pointer x, Pointer y) {
        VecFloat.call("remainder", n, n, result, x, y);
    }
}

