/*
 * Decompiled with CFR 0.152.
 */
package jcuda.vec;

import jcuda.CudaException;
import jcuda.Pointer;
import jcuda.vec.DefaultVecKernels;
import jcuda.vec.VecKernels;

public class VecDouble {
    private static VecKernels vecKernels = null;

    private VecDouble() {
    }

    public static void init() {
        VecDouble.shutdown();
        String kernelNamePrefix = "vec_";
        String kernelNameType = "double";
        String kernelNameSuffix = "";
        vecKernels = new DefaultVecKernels(kernelNameType, kernelNamePrefix, kernelNameSuffix);
    }

    public static void shutdown() {
        if (vecKernels != null) {
            vecKernels.shutdown();
            vecKernels = null;
        }
    }

    private static void call(String name, long workSize, Object ... arguments) {
        if (vecKernels == null) {
            throw new CudaException("Kernels not initialized. Call init() first.");
        }
        vecKernels.call(name, workSize, arguments);
    }

    public static void set(long n, Pointer result, double value) {
        VecDouble.call("set", n, n, result, value);
    }

    public static void add(long n, Pointer result, Pointer x, Pointer y) {
        VecDouble.call("add", n, n, result, x, y);
    }

    public static void sub(long n, Pointer result, Pointer x, Pointer y) {
        VecDouble.call("sub", n, n, result, x, y);
    }

    public static void mul(long n, Pointer result, Pointer x, Pointer y) {
        VecDouble.call("mul", n, n, result, x, y);
    }

    public static void div(long n, Pointer result, Pointer x, Pointer y) {
        VecDouble.call("div", n, n, result, x, y);
    }

    public static void negate(long n, Pointer result, Pointer x) {
        VecDouble.call("negate", n, n, result, x);
    }

    public static void addScalar(long n, Pointer result, Pointer x, double y) {
        VecDouble.call("addScalar", n, n, result, x, y);
    }

    public static void subScalar(long n, Pointer result, Pointer x, double y) {
        VecDouble.call("subScalar", n, n, result, x, y);
    }

    public static void mulScalar(long n, Pointer result, Pointer x, double y) {
        VecDouble.call("mulScalar", n, n, result, x, y);
    }

    public static void divScalar(long n, Pointer result, Pointer x, double y) {
        VecDouble.call("divScalar", n, n, result, x, y);
    }

    public static void scalarAdd(long n, Pointer result, double x, Pointer y) {
        VecDouble.call("scalarAdd", n, n, result, x, y);
    }

    public static void scalarSub(long n, Pointer result, double x, Pointer y) {
        VecDouble.call("scalarSub", n, n, result, x, y);
    }

    public static void scalarMul(long n, Pointer result, double x, Pointer y) {
        VecDouble.call("scalarMul", n, n, result, x, y);
    }

    public static void scalarDiv(long n, Pointer result, double x, Pointer y) {
        VecDouble.call("scalarDiv", n, n, result, x, y);
    }

    public static void lt(long n, Pointer result, Pointer x, Pointer y) {
        VecDouble.call("lt", n, n, result, x, y);
    }

    public static void lte(long n, Pointer result, Pointer x, Pointer y) {
        VecDouble.call("lte", n, n, result, x, y);
    }

    public static void eq(long n, Pointer result, Pointer x, Pointer y) {
        VecDouble.call("eq", n, n, result, x, y);
    }

    public static void gte(long n, Pointer result, Pointer x, Pointer y) {
        VecDouble.call("gte", n, n, result, x, y);
    }

    public static void gt(long n, Pointer result, Pointer x, Pointer y) {
        VecDouble.call("gt", n, n, result, x, y);
    }

    public static void ne(long n, Pointer result, Pointer x, Pointer y) {
        VecDouble.call("ne", n, n, result, x, y);
    }

    public static void ltScalar(long n, Pointer result, Pointer x, double y) {
        VecDouble.call("ltScalar", n, n, result, x, y);
    }

    public static void lteScalar(long n, Pointer result, Pointer x, double y) {
        VecDouble.call("lteScalar", n, n, result, x, y);
    }

    public static void eqScalar(long n, Pointer result, Pointer x, double y) {
        VecDouble.call("eqScalar", n, n, result, x, y);
    }

    public static void gteScalar(long n, Pointer result, Pointer x, double y) {
        VecDouble.call("gteScalar", n, n, result, x, y);
    }

    public static void gtScalar(long n, Pointer result, Pointer x, double y) {
        VecDouble.call("gtScalar", n, n, result, x, y);
    }

    public static void neScalar(long n, Pointer result, Pointer x, double y) {
        VecDouble.call("neScalar", n, n, result, x, y);
    }

    public static void acos(long n, Pointer result, Pointer x) {
        VecDouble.call("acos", n, n, result, x);
    }

    public static void acosh(long n, Pointer result, Pointer x) {
        VecDouble.call("acosh", n, n, result, x);
    }

    public static void asin(long n, Pointer result, Pointer x) {
        VecDouble.call("asin", n, n, result, x);
    }

    public static void asinh(long n, Pointer result, Pointer x) {
        VecDouble.call("asinh", n, n, result, x);
    }

    public static void atan(long n, Pointer result, Pointer x) {
        VecDouble.call("atan", n, n, result, x);
    }

    public static void atanh(long n, Pointer result, Pointer x) {
        VecDouble.call("atanh", n, n, result, x);
    }

    public static void cbrt(long n, Pointer result, Pointer x) {
        VecDouble.call("cbrt", n, n, result, x);
    }

    public static void ceil(long n, Pointer result, Pointer x) {
        VecDouble.call("ceil", n, n, result, x);
    }

    public static void cos(long n, Pointer result, Pointer x) {
        VecDouble.call("cos", n, n, result, x);
    }

    public static void cosh(long n, Pointer result, Pointer x) {
        VecDouble.call("cosh", n, n, result, x);
    }

    public static void cospi(long n, Pointer result, Pointer x) {
        VecDouble.call("cospi", n, n, result, x);
    }

    public static void erfc(long n, Pointer result, Pointer x) {
        VecDouble.call("erfc", n, n, result, x);
    }

    public static void erfcinv(long n, Pointer result, Pointer x) {
        VecDouble.call("erfcinv", n, n, result, x);
    }

    public static void erfcx(long n, Pointer result, Pointer x) {
        VecDouble.call("erfcx", n, n, result, x);
    }

    public static void erf(long n, Pointer result, Pointer x) {
        VecDouble.call("erf", n, n, result, x);
    }

    public static void erfinv(long n, Pointer result, Pointer x) {
        VecDouble.call("erfinv", n, n, result, x);
    }

    public static void exp10(long n, Pointer result, Pointer x) {
        VecDouble.call("exp10", n, n, result, x);
    }

    public static void exp2(long n, Pointer result, Pointer x) {
        VecDouble.call("exp2", n, n, result, x);
    }

    public static void exp(long n, Pointer result, Pointer x) {
        VecDouble.call("exp", n, n, result, x);
    }

    public static void expm1(long n, Pointer result, Pointer x) {
        VecDouble.call("expm1", n, n, result, x);
    }

    public static void fabs(long n, Pointer result, Pointer x) {
        VecDouble.call("fabs", n, n, result, x);
    }

    public static void floor(long n, Pointer result, Pointer x) {
        VecDouble.call("floor", n, n, result, x);
    }

    public static void j0(long n, Pointer result, Pointer x) {
        VecDouble.call("j0", n, n, result, x);
    }

    public static void j1(long n, Pointer result, Pointer x) {
        VecDouble.call("j1", n, n, result, x);
    }

    public static void lgamma(long n, Pointer result, Pointer x) {
        VecDouble.call("lgamma", n, n, result, x);
    }

    public static void log10(long n, Pointer result, Pointer x) {
        VecDouble.call("log10", n, n, result, x);
    }

    public static void log1p(long n, Pointer result, Pointer x) {
        VecDouble.call("log1p", n, n, result, x);
    }

    public static void log2(long n, Pointer result, Pointer x) {
        VecDouble.call("log2", n, n, result, x);
    }

    public static void logb(long n, Pointer result, Pointer x) {
        VecDouble.call("logb", n, n, result, x);
    }

    public static void log(long n, Pointer result, Pointer x) {
        VecDouble.call("log", n, n, result, x);
    }

    public static void normcdf(long n, Pointer result, Pointer x) {
        VecDouble.call("normcdf", n, n, result, x);
    }

    public static void normcdfinv(long n, Pointer result, Pointer x) {
        VecDouble.call("normcdfinv", n, n, result, x);
    }

    public static void rcbrt(long n, Pointer result, Pointer x) {
        VecDouble.call("rcbrt", n, n, result, x);
    }

    public static void rint(long n, Pointer result, Pointer x) {
        VecDouble.call("rint", n, n, result, x);
    }

    public static void round(long n, Pointer result, Pointer x) {
        VecDouble.call("round", n, n, result, x);
    }

    public static void rsqrt(long n, Pointer result, Pointer x) {
        VecDouble.call("rsqrt", n, n, result, x);
    }

    public static void sin(long n, Pointer result, Pointer x) {
        VecDouble.call("sin", n, n, result, x);
    }

    public static void sinh(long n, Pointer result, Pointer x) {
        VecDouble.call("sinh", n, n, result, x);
    }

    public static void sinpi(long n, Pointer result, Pointer x) {
        VecDouble.call("sinpi", n, n, result, x);
    }

    public static void sqrt(long n, Pointer result, Pointer x) {
        VecDouble.call("sqrt", n, n, result, x);
    }

    public static void tan(long n, Pointer result, Pointer x) {
        VecDouble.call("tan", n, n, result, x);
    }

    public static void tanh(long n, Pointer result, Pointer x) {
        VecDouble.call("tanh", n, n, result, x);
    }

    public static void tgamma(long n, Pointer result, Pointer x) {
        VecDouble.call("tgamma", n, n, result, x);
    }

    public static void trunc(long n, Pointer result, Pointer x) {
        VecDouble.call("trunc", n, n, result, x);
    }

    public static void y0(long n, Pointer result, Pointer x) {
        VecDouble.call("y0", n, n, result, x);
    }

    public static void y1(long n, Pointer result, Pointer x) {
        VecDouble.call("y1", n, n, result, x);
    }

    public static void copysign(long n, Pointer result, Pointer x, Pointer y) {
        VecDouble.call("copysign", n, n, result, x, y);
    }

    public static void fdim(long n, Pointer result, Pointer x, Pointer y) {
        VecDouble.call("fdim", n, n, result, x, y);
    }

    public static void fdivide(long n, Pointer result, Pointer x, Pointer y) {
        VecDouble.call("fdivide", n, n, result, x, y);
    }

    public static void fmax(long n, Pointer result, Pointer x, Pointer y) {
        VecDouble.call("fmax", n, n, result, x, y);
    }

    public static void fmin(long n, Pointer result, Pointer x, Pointer y) {
        VecDouble.call("fmin", n, n, result, x, y);
    }

    public static void fmod(long n, Pointer result, Pointer x, Pointer y) {
        VecDouble.call("fmod", n, n, result, x, y);
    }

    public static void hypot(long n, Pointer result, Pointer x, Pointer y) {
        VecDouble.call("hypot", n, n, result, x, y);
    }

    public static void nextafter(long n, Pointer result, Pointer x, Pointer y) {
        VecDouble.call("nextafter", n, n, result, x, y);
    }

    public static void pow(long n, Pointer result, Pointer x, Pointer y) {
        VecDouble.call("pow", n, n, result, x, y);
    }

    public static void remainder(long n, Pointer result, Pointer x, Pointer y) {
        VecDouble.call("remainder", n, n, result, x, y);
    }
}

