/*
 * Decompiled with CFR 0.152.
 */
package jcommon.graph.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jcommon.graph.ITopologicalSortInput;

public class TopologicalSortInput<TValue, TProcessedValue>
implements ITopologicalSortInput<TValue, TProcessedValue> {
    private final boolean starting;
    private final Map<TValue, TProcessedValue> inputs;

    public TopologicalSortInput(boolean starting, Map<TValue, TProcessedValue> inputs) {
        if (inputs == null) {
            throw new IllegalArgumentException("inputs cannot be empty");
        }
        this.starting = starting;
        this.inputs = Collections.unmodifiableMap(new HashMap<TValue, TProcessedValue>(inputs));
    }

    @Override
    public boolean isStart() {
        return this.starting;
    }

    @Override
    public boolean isEmpty() {
        return this.inputs.isEmpty();
    }

    @Override
    public TProcessedValue get(TValue value) {
        return this.inputs.get(value);
    }

    @Override
    public TProcessedValue first() {
        if (this.inputs.isEmpty()) {
            return null;
        }
        return this.inputs.values().iterator().next();
    }

    @Override
    public int size() {
        return this.inputs.size();
    }

    @Override
    public boolean contains(TValue value) {
        return this.inputs.containsKey(value);
    }

    @Override
    public Iterable<TProcessedValue> inputs() {
        return this.inputs.values();
    }

    @Override
    public Set<TValue> values() {
        return this.inputs.keySet();
    }

    public String toString() {
        return this.inputs().toString();
    }
}

