/*
 * Decompiled with CFR 0.152.
 */
package jcommon.graph.impl;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import jcommon.graph.ITopologicalSortAsyncResult;

final class TopologicalSortAsyncResult<TValue, TProcessedValue>
implements ITopologicalSortAsyncResult<TValue, TProcessedValue> {
    private final Object lock = new Object();
    private final ExecutorService executor;
    private final CountDownLatch latch;
    private boolean done;
    private boolean successful;
    private boolean discontinue_processing;
    private Map<TValue, TProcessedValue> results;

    public TopologicalSortAsyncResult(ExecutorService executor) {
        this.executor = executor;
        this.latch = new CountDownLatch(1);
        this.done = false;
        this.successful = false;
        this.discontinue_processing = false;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isProcessingDiscontinued() {
        return this.discontinue_processing;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean discontinueScheduling() {
        Object object = this.lock;
        synchronized (object) {
            this.discontinue_processing = true;
        }
        return true;
    }

    Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncComplete(Map<TValue, TProcessedValue> results, boolean successful) {
        Object object = this.lock;
        synchronized (object) {
            this.results = results;
            this.successful = successful;
            this.done = true;
            this.latch.countDown();
        }
    }

    @Override
    public boolean waitForCompletion() {
        return this.awaitUninterruptibly() && this.isSuccessful();
    }

    @Override
    public boolean waitForCompletion(long timeout, TimeUnit unit) {
        return this.awaitUninterruptibly(timeout, unit) && this.isSuccessful();
    }

    @Override
    public boolean awaitUninterruptibly() {
        try {
            return this.await();
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        try {
            return this.await(timeout, unit);
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    @Override
    public boolean await() throws InterruptedException {
        this.latch.await();
        return true;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit);
    }

    @Override
    public boolean isEmpty() {
        return !this.isDone() || this.results.isEmpty();
    }

    @Override
    public TProcessedValue get(TValue value) {
        return this.resultFor(value);
    }

    @Override
    public TProcessedValue first() {
        if (!this.isDone() || this.results.isEmpty()) {
            return null;
        }
        return this.results.values().iterator().next();
    }

    @Override
    public TProcessedValue resultFor(TValue value) {
        return this.isDone() ? (TProcessedValue)this.results.get(value) : null;
    }

    @Override
    public int size() {
        return this.isDone() ? this.results.size() : 0;
    }

    @Override
    public boolean contains(TValue value) {
        return this.isDone() ? this.results.containsKey(value) : false;
    }

    @Override
    public Iterable<TProcessedValue> results() {
        return this.isDone() ? this.results.values() : new ArrayList(0);
    }

    @Override
    public Iterable<TValue> endingValues() {
        return this.isDone() ? this.results.keySet() : new ArrayList(0);
    }
}

