/*
 * Decompiled with CFR 0.152.
 */
package jcommon.graph.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jcommon.graph.IAdjacencyList;
import jcommon.graph.IAdjacencyListPair;
import jcommon.graph.IEdge;
import jcommon.graph.IVertex;
import jcommon.graph.impl.AdjacencyListPair;

public class AdjacencyList<TVertex extends IVertex<TValue>, TValue, TProcessedValue>
implements IAdjacencyList<TVertex, TValue, TProcessedValue> {
    private final List<IAdjacencyListPair<TVertex>> num_map;
    private final Map<TVertex, Integer> index_map;
    private final Map<TVertex, List<TVertex>> vertex_map;
    private final Set<TVertex> end_vertices;

    public AdjacencyList(Set<TVertex> vertices, Set<IEdge<TVertex>> edges) {
        ArrayList<AdjacencyListPair<IVertex>> num_map = new ArrayList<AdjacencyListPair<IVertex>>(vertices.size());
        HashMap vertex_map = new HashMap(vertices.size(), 1.0f);
        HashMap<IVertex, Integer> index_map = new HashMap<IVertex, Integer>(vertices.size(), 1.0f);
        ArrayList EMPTY_VERTICES_ARRAYLIST = new ArrayList(0);
        HashSet<IVertex> end_vertices = new HashSet<IVertex>(2, 1.0f);
        for (IVertex d : vertices) {
            ArrayList<TVertex> al_to = new ArrayList<TVertex>();
            for (IEdge<TVertex> r : edges) {
                if (!d.equals(r.getFrom())) continue;
                al_to.add(r.getTo());
            }
            ArrayList<TVertex> arr_to = !al_to.isEmpty() ? al_to : EMPTY_VERTICES_ARRAYLIST;
            vertex_map.put(d, arr_to);
            num_map.add(new AdjacencyListPair<IVertex>(d, (List<IVertex>)arr_to));
            index_map.put(d, num_map.size() - 1);
            if (!arr_to.isEmpty()) continue;
            end_vertices.add(d);
        }
        this.num_map = Collections.unmodifiableList(num_map);
        this.index_map = Collections.unmodifiableMap(index_map);
        this.vertex_map = Collections.unmodifiableMap(vertex_map);
        this.end_vertices = Collections.unmodifiableSet(end_vertices);
    }

    @Override
    public int[] calculateInDegrees() {
        int[] in_degrees = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            IAdjacencyListPair<TVertex> p = this.pairAt(i);
            TVertex d = p.getVertex();
            for (int j = 0; j < this.size(); ++j) {
                for (IVertex dep : this.pairAt(j).getOutNeighbors()) {
                    if (!d.equals(dep)) continue;
                    int n = i;
                    in_degrees[n] = in_degrees[n] + 1;
                }
            }
        }
        return in_degrees;
    }

    @Override
    public IAdjacencyListPair<TVertex> pairAt(int index) {
        return this.num_map.get(index);
    }

    @Override
    public List<TVertex> outNeighborsAt(int index) {
        IAdjacencyListPair<TVertex> pair = this.pairAt(index);
        return pair.getOutNeighbors();
    }

    @Override
    public List<TVertex> outNeighborsFor(TVertex vertex) {
        return this.vertex_map.get(vertex);
    }

    @Override
    public boolean isEmpty() {
        return this.vertex_map.isEmpty();
    }

    @Override
    public int size() {
        return this.vertex_map.size();
    }

    @Override
    public Set<TVertex> getEndingVertices() {
        return this.end_vertices;
    }

    @Override
    public Iterator<IAdjacencyListPair<TVertex>> iterator() {
        return this.num_map.iterator();
    }

    @Override
    public int indexOf(IVertex vertex) {
        Integer result = this.index_map.get(vertex);
        return result != null ? result : -1;
    }

    @Override
    public boolean isEndingVertex(TVertex vertex) {
        return this.end_vertices.contains(vertex);
    }

    @Override
    public Map<TValue, TProcessedValue> createResultMap() {
        return new HashMap(this.end_vertices.size());
    }
}

