/*
 * Decompiled with CFR 0.152.
 */
package jcommon.graph;

import jcommon.graph.DirectedAcyclicGraph;
import jcommon.graph.IVertex;
import jcommon.graph.ObjectVertex;

public class ObjectGraph<TValue, TProcessedValue>
extends DirectedAcyclicGraph<IVertex<TValue>, TValue, TProcessedValue> {
    protected ObjectGraph() {
    }

    public ObjectGraph<TValue, TProcessedValue> copyAsObjectGraph() {
        return ObjectGraph.copyGraph(this);
    }

    public static <TValue, TProcessedValue> ObjectGraph<TValue, TProcessedValue> buildFromObjects(TValue ... vertices) {
        ObjectGraph<TValue, TProcessedValue> g = new ObjectGraph<TValue, TProcessedValue>();
        for (TValue v : vertices) {
            g.addVertex(v);
        }
        return g;
    }

    public static <TValue, TProcessedValue> ObjectGraph<TValue, TProcessedValue> createForObjects() {
        return ObjectGraph.buildFromObjects(new Object[0]);
    }

    public ObjectGraph<TValue, TProcessedValue> addVertex(TValue vertex) {
        super.addVertex(ObjectVertex.from(vertex));
        return this;
    }

    public ObjectGraph<TValue, TProcessedValue> removeVertex(TValue vertex) {
        super.removeVertex(ObjectVertex.from(vertex));
        return this;
    }

    public ObjectGraph<TValue, TProcessedValue> addEdge(TValue from, TValue to) {
        IVertex<TValue> t = to instanceof IVertex ? (IVertex<TValue>)to : ObjectVertex.from(to);
        IVertex<TValue> f = from instanceof IVertex ? (IVertex<TValue>)from : ObjectVertex.from(from);
        super.addEdge(f, t);
        return this;
    }

    public ObjectGraph<TValue, TProcessedValue> removeEdge(TValue from, TValue to) {
        IVertex<TValue> t = to instanceof IVertex ? (IVertex<TValue>)to : ObjectVertex.from(to);
        IVertex<TValue> f = from instanceof IVertex ? (IVertex<TValue>)from : ObjectVertex.from(from);
        super.removeEdge(f, t);
        return this;
    }
}

