/*
 * Decompiled with CFR 0.152.
 */
package jcommon.graph;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import jcommon.graph.CyclicGraphException;
import jcommon.graph.IEdge;
import jcommon.graph.ITopologicalSortAsyncResult;
import jcommon.graph.ITopologicalSortCallback;
import jcommon.graph.ITopologicalSortErrorCallback;
import jcommon.graph.ITopologicalSortStrategy;
import jcommon.graph.IVertex;

public interface IGraph<TVertex extends IVertex<TValue>, TValue, TProcessedValue> {
    public static final IVertex[] EMPTY_VERTICES = new IVertex[0];

    public Set<TVertex> getVertices();

    public Set<IEdge<TVertex>> getEdges();

    public IGraph<TVertex, TValue, TProcessedValue> copy();

    public IGraph<TVertex, TValue, TProcessedValue> addVertex(TVertex var1);

    public IGraph<TVertex, TValue, TProcessedValue> removeVertex(TVertex var1);

    public IGraph<TVertex, TValue, TProcessedValue> addEdge(TVertex var1, TVertex var2);

    public IGraph<TVertex, TValue, TProcessedValue> removeEdge(TVertex var1, TVertex var2);

    public boolean validate();

    public List<TValue> sort() throws CyclicGraphException;

    public List<TValue> sort(ITopologicalSortStrategy<TVertex, TValue, TProcessedValue> var1) throws CyclicGraphException;

    public ITopologicalSortAsyncResult<TValue, TProcessedValue> sortAsync(ITopologicalSortCallback<TValue, TProcessedValue> var1);

    public ITopologicalSortAsyncResult<TValue, TProcessedValue> sortAsync(ITopologicalSortCallback<TValue, TProcessedValue> var1, ITopologicalSortErrorCallback<TValue> var2);

    public ITopologicalSortAsyncResult<TValue, TProcessedValue> sortAsync(ITopologicalSortStrategy<TVertex, TValue, TProcessedValue> var1, ITopologicalSortCallback<TValue, TProcessedValue> var2);

    public ITopologicalSortAsyncResult<TValue, TProcessedValue> sortAsync(ITopologicalSortStrategy<TVertex, TValue, TProcessedValue> var1, ITopologicalSortCallback<TValue, TProcessedValue> var2, ITopologicalSortErrorCallback<TValue> var3);

    public ITopologicalSortAsyncResult<TValue, TProcessedValue> sortAsync(ExecutorService var1, ITopologicalSortCallback<TValue, TProcessedValue> var2);

    public ITopologicalSortAsyncResult<TValue, TProcessedValue> sortAsync(ExecutorService var1, ITopologicalSortCallback<TValue, TProcessedValue> var2, ITopologicalSortErrorCallback<TValue> var3);

    public ITopologicalSortAsyncResult<TValue, TProcessedValue> sortAsync(ExecutorService var1, ITopologicalSortStrategy<TVertex, TValue, TProcessedValue> var2, ITopologicalSortCallback<TValue, TProcessedValue> var3);

    public ITopologicalSortAsyncResult<TValue, TProcessedValue> sortAsync(ExecutorService var1, ITopologicalSortStrategy<TVertex, TValue, TProcessedValue> var2, ITopologicalSortCallback<TValue, TProcessedValue> var3, ITopologicalSortErrorCallback<TValue> var4);
}

