/*
 * Decompiled with CFR 0.152.
 */
package jcommon.graph.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jcommon.graph.ITopologicalSortInput;
import jcommon.graph.IVertex;

public class TopologicalSortInput<TValue>
implements ITopologicalSortInput<TValue> {
    private final boolean starting;
    private final Map<IVertex, TValue> inputs;

    public TopologicalSortInput(boolean starting, Map<IVertex, TValue> inputs) {
        if (inputs == null) {
            throw new IllegalArgumentException("inputs cannot be empty");
        }
        this.starting = starting;
        this.inputs = Collections.unmodifiableMap(new HashMap<IVertex, TValue>(inputs));
    }

    @Override
    public boolean isStart() {
        return this.starting;
    }

    @Override
    public boolean isEmpty() {
        return this.inputs.isEmpty();
    }

    @Override
    public TValue get(IVertex vertex) {
        return this.inputs.get(vertex);
    }

    @Override
    public TValue first() {
        if (this.inputs.isEmpty()) {
            return null;
        }
        return this.inputs.values().iterator().next();
    }

    @Override
    public int size() {
        return this.inputs.size();
    }

    @Override
    public boolean containsVertex(IVertex vertex) {
        return this.inputs.containsKey(vertex);
    }

    @Override
    public Iterable<TValue> inputs() {
        return this.inputs.values();
    }

    @Override
    public Set<IVertex> vertices() {
        return this.inputs.keySet();
    }

    public String toString() {
        return this.inputs().toString();
    }
}

