/*
 * Decompiled with CFR 0.152.
 */
package jcommon.graph;

import jcommon.graph.DirectedAcyclicGraph;
import jcommon.graph.IVertex;
import jcommon.graph.ObjectVertex;

public class ObjectGraph
extends DirectedAcyclicGraph<IVertex<Object>, Object> {
    protected ObjectGraph() {
    }

    public ObjectGraph copyAsObjectGraph() {
        return ObjectGraph.copyGraph(this);
    }

    public static ObjectGraph buildFromObjects(Object ... vertices) {
        ObjectGraph g = new ObjectGraph();
        for (Object v : vertices) {
            g.addVertex(v);
        }
        return g;
    }

    public static ObjectGraph createForObjects() {
        return ObjectGraph.buildFromObjects(new Object[0]);
    }

    public ObjectGraph addVertex(Object vertex) {
        super.addVertex(ObjectVertex.from(vertex));
        return this;
    }

    public ObjectGraph removeVertex(Object vertex) {
        super.removeVertex(ObjectVertex.from(vertex));
        return this;
    }

    public ObjectGraph addEdge(Object from, Object to) {
        IVertex t = to instanceof IVertex ? (IVertex)to : ObjectVertex.from(to);
        IVertex f = from instanceof IVertex ? (IVertex)from : ObjectVertex.from(from);
        super.addEdge(f, t);
        return this;
    }

    public ObjectGraph removeEdge(Object from, Object to) {
        IVertex t = to instanceof IVertex ? (IVertex)to : ObjectVertex.from(to);
        IVertex f = from instanceof IVertex ? (IVertex)from : ObjectVertex.from(from);
        super.removeEdge(f, t);
        return this;
    }
}

