/*
 * Decompiled with CFR 0.152.
 */
package jcommon.graph;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import jcommon.graph.CyclicGraphException;
import jcommon.graph.IEdge;
import jcommon.graph.ITopologicalSortAsyncResult;
import jcommon.graph.ITopologicalSortCallback;
import jcommon.graph.ITopologicalSortErrorCallback;
import jcommon.graph.ITopologicalSortStrategy;
import jcommon.graph.IVertex;

public interface IGraph<TVertex extends IVertex<TValue>, TValue> {
    public static final IVertex[] EMPTY_VERTICES = new IVertex[0];

    public Set<TVertex> getVertices();

    public Set<IEdge<TVertex>> getEdges();

    public IGraph<TVertex, TValue> copy();

    public IGraph<TVertex, TValue> addVertex(TVertex var1);

    public IGraph<TVertex, TValue> removeVertex(TVertex var1);

    public IGraph<TVertex, TValue> addEdge(TVertex var1, TVertex var2);

    public IGraph<TVertex, TValue> removeEdge(TVertex var1, TVertex var2);

    public boolean validate();

    public List<TValue> sort() throws CyclicGraphException;

    public List<TValue> sort(ITopologicalSortStrategy<TVertex, TValue> var1) throws CyclicGraphException;

    public ITopologicalSortAsyncResult<TValue> sortAsync(ITopologicalSortCallback<TValue> var1);

    public ITopologicalSortAsyncResult<TValue> sortAsync(ITopologicalSortCallback<TValue> var1, ITopologicalSortErrorCallback<TValue> var2);

    public ITopologicalSortAsyncResult<TValue> sortAsync(ITopologicalSortStrategy<TVertex, TValue> var1, ITopologicalSortCallback<TValue> var2);

    public ITopologicalSortAsyncResult<TValue> sortAsync(ITopologicalSortStrategy<TVertex, TValue> var1, ITopologicalSortCallback<TValue> var2, ITopologicalSortErrorCallback<TValue> var3);

    public ITopologicalSortAsyncResult<TValue> sortAsync(ExecutorService var1, ITopologicalSortCallback<TValue> var2);

    public ITopologicalSortAsyncResult<TValue> sortAsync(ExecutorService var1, ITopologicalSortCallback<TValue> var2, ITopologicalSortErrorCallback<TValue> var3);

    public ITopologicalSortAsyncResult<TValue> sortAsync(ExecutorService var1, ITopologicalSortStrategy<TVertex, TValue> var2, ITopologicalSortCallback<TValue> var3);

    public ITopologicalSortAsyncResult<TValue> sortAsync(ExecutorService var1, ITopologicalSortStrategy<TVertex, TValue> var2, ITopologicalSortCallback<TValue> var3, ITopologicalSortErrorCallback<TValue> var4);
}

