/*
  Copyright (C) 2012-2013 the original author or authors.

  See the LICENSE.txt file distributed with this work for additional
  information regarding copyright ownership.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package jcommon.graph;

import java.util.List;

/**
 * Maintains a reference between a {@link IVertex} ({@link #getVertex()}) and its
 * out-neighbors ({@link #getOutNeighbors()}). Meant for use in conjunction with {@link Pair}.
 *
 * @param <TVertex> Type of {@link IVertex}.
 *
 * @see Pair
 */
public interface IAdjacencyListPair<TVertex extends IVertex> {
  /**
   * The vertex for this pair.
   *
   * @return An instance of {@link IVertex} of type <code>TVertex</code>.
   */
  TVertex getVertex();

  /**
   * The list of out-neighbors for the vertex provided by {@link #getVertex()}.
   *
   * @return An instance of a list of {@link IVertex} of type <code>TVertex</code>.
   */
  List<TVertex> getOutNeighbors();
}
