/*
 * Decompiled with CFR 0.152.
 */
package jcommon.graph.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jcommon.graph.ITopologicalSortInput;
import jcommon.graph.IVertex;

public class TopologicalSortInput<TVertex extends IVertex>
implements ITopologicalSortInput<TVertex> {
    private final Map<TVertex, Object> inputs;

    public TopologicalSortInput(Map<TVertex, Object> inputs) {
        if (inputs == null) {
            throw new IllegalArgumentException("inputs cannot be empty");
        }
        this.inputs = Collections.unmodifiableMap(new HashMap<TVertex, Object>(inputs));
    }

    @Override
    public boolean isEmpty() {
        return this.inputs.isEmpty();
    }

    @Override
    public Object get(TVertex vertex) {
        return this.inputs.get(vertex);
    }

    @Override
    public int size() {
        return this.inputs.size();
    }

    @Override
    public boolean containsVertex(TVertex vertex) {
        return this.inputs.containsKey(vertex);
    }

    @Override
    public Iterable<Object> inputs() {
        return this.inputs.values();
    }

    @Override
    public Object[] getInputs() {
        return this.inputs.values().toArray(new Object[this.inputs.size()]);
    }

    public String toString() {
        return this.inputs().toString();
    }
}

