/*
 * Decompiled with CFR 0.152.
 */
package jcommon.graph.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import jcommon.graph.ITopologicalSortAsyncResult;

final class TopologicalSortAsyncResult
implements ITopologicalSortAsyncResult {
    private final Object lock = new Object();
    private final ExecutorService executor;
    private final CountDownLatch latch;
    private boolean done;
    private boolean successful;
    private boolean discontinue_processing;

    public TopologicalSortAsyncResult(ExecutorService executor) {
        this.executor = executor;
        this.latch = new CountDownLatch(1);
        this.done = false;
        this.successful = false;
        this.discontinue_processing = false;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isProcessingDiscontinued() {
        return this.discontinue_processing;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean discontinueScheduling() {
        Object object = this.lock;
        synchronized (object) {
            this.discontinue_processing = true;
        }
        return true;
    }

    Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncComplete(boolean successful) {
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
            this.successful = successful;
            this.latch.countDown();
        }
    }

    @Override
    public boolean waitForCompletion() {
        return this.awaitUninterruptibly() && this.isSuccessful();
    }

    @Override
    public boolean waitForCompletion(long timeout, TimeUnit unit) {
        return this.awaitUninterruptibly(timeout, unit) && this.isSuccessful();
    }

    @Override
    public boolean awaitUninterruptibly() {
        try {
            return this.await();
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        try {
            return this.await(timeout, unit);
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    @Override
    public boolean await() throws InterruptedException {
        this.latch.await();
        return true;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit);
    }
}

