/*
 * Decompiled with CFR 0.152.
 */
package jcommon.graph.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import jcommon.graph.CyclicGraphException;
import jcommon.graph.IAdjacencyList;
import jcommon.graph.IAdjacencyListPair;
import jcommon.graph.ITopologicalSortAsyncResult;
import jcommon.graph.ITopologicalSortCallback;
import jcommon.graph.ITopologicalSortErrorCallback;
import jcommon.graph.ITopologicalSortStrategy;
import jcommon.graph.IVertex;
import jcommon.graph.impl.TopologicalSortAsyncResult;
import jcommon.graph.impl.TopologicalSortCoordinator;
import jcommon.graph.impl.TopologicalSortInput;

public final class SimpleTopologicalSort<TVertex extends IVertex>
implements ITopologicalSortStrategy<TVertex> {
    @Override
    public List<TVertex> sort(IAdjacencyList<TVertex> adjacencyList) throws CyclicGraphException {
        IAdjacencyListPair p;
        if (adjacencyList.isEmpty()) {
            return new ArrayList(0);
        }
        boolean ordered_index = false;
        ArrayList ordered = new ArrayList(adjacencyList.size());
        LinkedList<IAdjacencyListPair<TVertex>> queue = new LinkedList<IAdjacencyListPair<TVertex>>();
        int[] in_degrees = adjacencyList.calculateInDegrees();
        for (int i = 0; i < in_degrees.length; ++i) {
            if (in_degrees[i] != 0) continue;
            queue.add(adjacencyList.pairAt(i));
        }
        if (queue.isEmpty()) {
            throw new CyclicGraphException("Cycle detected when topologically sorting the graph");
        }
        while ((p = (IAdjacencyListPair)queue.poll()) != null) {
            ordered.add(p.getVertex());
            for (IVertex d : p.getOutNeighbors()) {
                int index = adjacencyList.indexOf(d);
                if (in_degrees[index] == 1) {
                    queue.add(adjacencyList.pairAt(index));
                }
                int n = index;
                in_degrees[n] = in_degrees[n] - 1;
            }
        }
        if (ordered.size() != adjacencyList.size()) {
            throw new CyclicGraphException("Cycle detected when topologically sorting the graph");
        }
        return ordered;
    }

    @Override
    public ITopologicalSortAsyncResult sortAsync(final ExecutorService executorProcessors, final IAdjacencyList<TVertex> adjacencyList, final ITopologicalSortCallback<TVertex> callback, final ITopologicalSortErrorCallback<TVertex> errorCallback) {
        Callable callable;
        final TopologicalSortAsyncResult asyncResult = new TopologicalSortAsyncResult(executorProcessors);
        if (adjacencyList.isEmpty()) {
            asyncResult.asyncComplete(true);
            return asyncResult;
        }
        LinkedList<1> queue = new LinkedList<1>();
        int[] in_degrees = adjacencyList.calculateInDegrees();
        final ArrayList<1> callables = new ArrayList<1>(in_degrees.length);
        final HashSet<IAdjacencyListPair<TVertex>> remaining = new HashSet<IAdjacencyListPair<TVertex>>();
        AtomicInteger[] atomics = new AtomicInteger[in_degrees.length];
        final ArrayList inputs = new ArrayList(in_degrees.length);
        final AtomicInteger outstanding_submissions = new AtomicInteger(0);
        final TopologicalSortCoordinator coordinator = new TopologicalSortCoordinator(asyncResult);
        for (int i = 0; i < in_degrees.length; ++i) {
            final IAdjacencyListPair<TVertex> pair = adjacencyList.pairAt(i);
            final AtomicInteger atom = atomics[i] = new AtomicInteger(in_degrees[i] == 0 ? 1 : in_degrees[i]);
            final HashMap my_input = new HashMap(in_degrees[i], 1.0f);
            inputs.add(my_input);
            remaining.add(pair);
            Callable<Object> callable2 = new Callable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object call() throws Exception {
                    boolean handle_all_done;
                    block22: {
                        Throwable handled_exception = null;
                        handle_all_done = false;
                        Object vertex = pair.getVertex();
                        try {
                            int outstanding;
                            if (atom.decrementAndGet() == 0) {
                                TopologicalSortInput input;
                                Object object = remaining;
                                synchronized (object) {
                                    remaining.remove(pair);
                                }
                                object = my_input;
                                synchronized (object) {
                                    input = new TopologicalSortInput(my_input);
                                }
                                Object result = null;
                                try {
                                    result = callback.handle(vertex, input, coordinator);
                                }
                                catch (Throwable t) {
                                    handled_exception = t;
                                }
                                if (!asyncResult.isProcessingDiscontinued()) {
                                    for (IVertex dep : pair.getOutNeighbors()) {
                                        Map dep_inputs;
                                        int index = adjacencyList.indexOf(dep);
                                        Callable dep_callable = (Callable)callables.get(index);
                                        Map map = dep_inputs = (Map)inputs.get(index);
                                        synchronized (map) {
                                            dep_inputs.put(vertex, result);
                                        }
                                        outstanding_submissions.incrementAndGet();
                                        executorProcessors.submit(dep_callable);
                                    }
                                }
                            }
                            if ((outstanding = outstanding_submissions.decrementAndGet()) == 0) {
                                handle_all_done = true;
                                if (remaining.size() > 0) {
                                    throw new CyclicGraphException("Cycle detected when topologically sorting the graph");
                                }
                            }
                            if (handled_exception != null) {
                                throw handled_exception;
                            }
                        }
                        catch (Throwable t) {
                            if (errorCallback == null) break block22;
                            try {
                                errorCallback.handleError(vertex, t, coordinator);
                            }
                            catch (Throwable t2) {
                                // empty catch block
                            }
                        }
                    }
                    if (handle_all_done) {
                        asyncResult.asyncComplete(remaining.size() == 0);
                    }
                    return null;
                }
            };
            callables.add(callable2);
            if (in_degrees[i] != 0) continue;
            queue.add(callable2);
        }
        if (queue.isEmpty()) {
            if (errorCallback != null) {
                errorCallback.handleError(null, new CyclicGraphException("Cycle detected when topologically sorting the graph"), coordinator);
            }
            asyncResult.asyncComplete(false);
            return asyncResult;
        }
        outstanding_submissions.set(queue.size());
        while ((callable = (Callable)queue.poll()) != null) {
            executorProcessors.submit(callable);
        }
        return asyncResult;
    }
}

