/*
 * Decompiled with CFR 0.152.
 */
package jcommon.graph;

import jcommon.graph.DirectedAcyclicGraph;
import jcommon.graph.NumberVertex;

public class NumberGraph
extends DirectedAcyclicGraph<NumberVertex> {
    protected NumberGraph() {
    }

    public NumberGraph copyAsNumberGraph() {
        return NumberGraph.copyGraph(this);
    }

    public static NumberGraph buildFromNumbers(Number ... vertices) {
        NumberGraph g = new NumberGraph();
        for (Number d : vertices) {
            g.addVertex(d);
        }
        return g;
    }

    public static NumberGraph createForNumbers() {
        return NumberGraph.buildFromNumbers(new Number[0]);
    }

    public NumberGraph addVertex(Number vertex) {
        this.addVertex(NumberVertex.from(vertex));
        return this;
    }

    public NumberGraph removeVertex(Number vertex) {
        this.removeVertex(NumberVertex.from(vertex));
        return this;
    }

    public NumberGraph addEdge(Number from, Number to) {
        this.addEdge(NumberVertex.from(from), NumberVertex.from(to));
        return this;
    }

    public NumberGraph removeEdge(Number from, Number to) {
        this.removeEdge(NumberVertex.from(from), NumberVertex.from(to));
        return this;
    }
}

