/*
 * Decompiled with CFR 0.152.
 */
package jcommon.graph;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import jcommon.graph.CyclicGraphException;
import jcommon.graph.IEdge;
import jcommon.graph.ITopologicalSortAsyncResult;
import jcommon.graph.ITopologicalSortCallback;
import jcommon.graph.ITopologicalSortErrorCallback;
import jcommon.graph.ITopologicalSortStrategy;
import jcommon.graph.IVertex;

public interface IGraph<TVertex extends IVertex> {
    public static final IVertex[] EMPTY_VERTICES = new IVertex[0];

    public Set<TVertex> getVertices();

    public Set<IEdge<TVertex>> getEdges();

    public IGraph<TVertex> copy();

    public IGraph<TVertex> addVertex(TVertex var1);

    public IGraph<TVertex> removeVertex(TVertex var1);

    public IGraph<TVertex> addEdge(TVertex var1, TVertex var2);

    public IGraph<TVertex> removeEdge(TVertex var1, TVertex var2);

    public boolean validate();

    public List<TVertex> sort() throws CyclicGraphException;

    public List<TVertex> sort(ITopologicalSortStrategy<TVertex> var1) throws CyclicGraphException;

    public ITopologicalSortAsyncResult sortAsync(ITopologicalSortCallback<TVertex> var1);

    public ITopologicalSortAsyncResult sortAsync(ITopologicalSortCallback<TVertex> var1, ITopologicalSortErrorCallback<TVertex> var2);

    public ITopologicalSortAsyncResult sortAsync(ITopologicalSortStrategy<TVertex> var1, ITopologicalSortCallback<TVertex> var2);

    public ITopologicalSortAsyncResult sortAsync(ITopologicalSortStrategy<TVertex> var1, ITopologicalSortCallback<TVertex> var2, ITopologicalSortErrorCallback<TVertex> var3);

    public ITopologicalSortAsyncResult sortAsync(ExecutorService var1, ITopologicalSortCallback<TVertex> var2);

    public ITopologicalSortAsyncResult sortAsync(ExecutorService var1, ITopologicalSortCallback<TVertex> var2, ITopologicalSortErrorCallback<TVertex> var3);

    public ITopologicalSortAsyncResult sortAsync(ExecutorService var1, ITopologicalSortStrategy<TVertex> var2, ITopologicalSortCallback<TVertex> var3);

    public ITopologicalSortAsyncResult sortAsync(ExecutorService var1, ITopologicalSortStrategy<TVertex> var2, ITopologicalSortCallback<TVertex> var3, ITopologicalSortErrorCallback<TVertex> var4);
}

