/*
 * Decompiled with CFR 0.152.
 */
package jcommon.graph;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jcommon.graph.CyclicGraphException;
import jcommon.graph.IEdge;
import jcommon.graph.IGraph;
import jcommon.graph.ITopologicalSortAsyncResult;
import jcommon.graph.ITopologicalSortCallback;
import jcommon.graph.ITopologicalSortErrorCallback;
import jcommon.graph.ITopologicalSortStrategy;
import jcommon.graph.IVertex;
import jcommon.graph.impl.AdjacencyList;
import jcommon.graph.impl.Edge;
import jcommon.graph.impl.SimpleTopologicalSort;

public class DirectedAcyclicGraph<TVertex extends IVertex>
implements Cloneable,
IGraph<TVertex> {
    private Set<TVertex> vertices = new LinkedHashSet<TVertex>(5, 0.8f);
    private Set<IEdge<TVertex>> edges = new LinkedHashSet<IEdge<TVertex>>(8, 0.8f);

    protected DirectedAcyclicGraph() {
    }

    @Override
    public Set<TVertex> getVertices() {
        return Collections.unmodifiableSet(this.vertices);
    }

    @Override
    public Set<IEdge<TVertex>> getEdges() {
        return Collections.unmodifiableSet(this.edges);
    }

    protected Object clone() throws CloneNotSupportedException {
        return DirectedAcyclicGraph.copyGraph(this);
    }

    protected static <TVertex extends IVertex, TGraph extends DirectedAcyclicGraph<TVertex>> TGraph copyGraph(TGraph graph) {
        try {
            Class<?> g_class = graph.getClass();
            Constructor<?> construct = g_class.getDeclaredConstructor(new Class[0]);
            construct.setAccessible(true);
            DirectedAcyclicGraph g = (DirectedAcyclicGraph)construct.newInstance(new Object[0]);
            g.vertices = new LinkedHashSet<TVertex>(graph.vertices);
            g.edges = new LinkedHashSet<IEdge<TVertex>>(graph.edges);
            return (TGraph)g;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public IGraph<TVertex> copy() {
        return DirectedAcyclicGraph.copyGraph(this);
    }

    public static <TVertex extends IVertex> IGraph<TVertex> build(TVertex ... vertices) {
        DirectedAcyclicGraph<TVertex> g = new DirectedAcyclicGraph<TVertex>();
        if (vertices != null) {
            for (TVertex d : vertices) {
                g.addVertex(d);
            }
        }
        return g;
    }

    public static <TVertex extends IVertex> IGraph<TVertex> create() {
        return DirectedAcyclicGraph.build((IVertex[])null);
    }

    @Override
    public IGraph<TVertex> addVertex(TVertex vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("vertex must not be null");
        }
        this.vertices.add(vertex);
        return this;
    }

    @Override
    public IGraph<TVertex> removeVertex(TVertex vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("vertex must not be null");
        }
        this.vertices.remove(vertex);
        return this;
    }

    @Override
    public IGraph<TVertex> addEdge(TVertex from, TVertex to) {
        this.edges.add(new Edge<TVertex>(from, to));
        return this;
    }

    @Override
    public IGraph<TVertex> removeEdge(TVertex from, TVertex to) {
        this.edges.remove(new Edge<TVertex>(from, to));
        return this;
    }

    @Override
    public boolean validate() {
        for (IEdge<TVertex> r : this.edges) {
            if (this.vertices.contains(r.getFrom()) && this.vertices.contains(r.getTo())) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<TVertex> sort() throws CyclicGraphException {
        return this.sort(new SimpleTopologicalSort());
    }

    @Override
    public List<TVertex> sort(ITopologicalSortStrategy<TVertex> strategy) throws CyclicGraphException {
        if (strategy == null) {
            throw new IllegalArgumentException("strategy cannot be null");
        }
        if (!this.validate()) {
            throw new IllegalStateException("The graph is invalid. Please confirm that all vertices are present for every relationship.");
        }
        return strategy.sort(new AdjacencyList<TVertex>(this.vertices, this.edges));
    }

    @Override
    public ITopologicalSortAsyncResult sortAsync(ITopologicalSortCallback<TVertex> callback) {
        return this.sortAsync(new SimpleTopologicalSort(), callback, null);
    }

    @Override
    public ITopologicalSortAsyncResult sortAsync(ITopologicalSortCallback<TVertex> callback, ITopologicalSortErrorCallback<TVertex> errorCallback) {
        return this.sortAsync(new SimpleTopologicalSort(), callback, errorCallback);
    }

    @Override
    public ITopologicalSortAsyncResult sortAsync(ITopologicalSortStrategy<TVertex> strategy, ITopologicalSortCallback<TVertex> callback) {
        return this.sortAsync(strategy, callback, null);
    }

    @Override
    public ITopologicalSortAsyncResult sortAsync(ITopologicalSortStrategy<TVertex> strategy, ITopologicalSortCallback<TVertex> callback, ITopologicalSortErrorCallback<TVertex> errorCallback) {
        ExecutorService executor = Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors() + 1));
        ITopologicalSortAsyncResult result = this.sortAsync(executor, strategy, callback, errorCallback);
        return result;
    }

    @Override
    public ITopologicalSortAsyncResult sortAsync(ExecutorService executor, ITopologicalSortCallback<TVertex> callback) {
        return this.sortAsync(executor, new SimpleTopologicalSort(), callback, null);
    }

    @Override
    public ITopologicalSortAsyncResult sortAsync(ExecutorService executor, ITopologicalSortCallback<TVertex> callback, ITopologicalSortErrorCallback<TVertex> errorCallback) {
        return this.sortAsync(executor, new SimpleTopologicalSort(), callback, errorCallback);
    }

    @Override
    public ITopologicalSortAsyncResult sortAsync(ExecutorService executor, ITopologicalSortStrategy<TVertex> strategy, ITopologicalSortCallback<TVertex> callback) {
        return this.sortAsync(executor, strategy, callback, null);
    }

    @Override
    public ITopologicalSortAsyncResult sortAsync(ExecutorService executor, ITopologicalSortStrategy<TVertex> strategy, ITopologicalSortCallback<TVertex> callback, ITopologicalSortErrorCallback<TVertex> errorCallback) {
        if (strategy == null) {
            throw new IllegalArgumentException("strategy cannot be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        if (!this.validate()) {
            throw new IllegalStateException("The graph is invalid. Please confirm that all vertices are present for every relationship.");
        }
        return strategy.sortAsync(executor, new AdjacencyList<TVertex>(this.vertices, this.edges), callback, errorCallback);
    }
}

