/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.VCloudExpressVAppTemplate;
import org.jclouds.vcloud.domain.internal.VCloudExpressVAppTemplateImpl;
import org.jclouds.vcloud.xml.VCloudExpressVAppTemplateHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class VCloudExpressVAppTemplateHandlerTest {
    private Injector injector;
    private ParseSax.Factory factory;

    public void testTerremark() {
        InputStream is = this.getClass().getResourceAsStream("/vAppTemplate-trmk.xml");
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        VCloudExpressVAppTemplate result = (VCloudExpressVAppTemplate)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(VCloudExpressVAppTemplateHandler.class)).parse(is);
        Assert.assertEquals((Object)result, (Object)new VCloudExpressVAppTemplateImpl("CentOS 5.3 (32-bit)", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vAppTemplate/5"), "description of CentOS 5.3 (32-bit)", null));
    }

    public void testHosting() {
        InputStream is = this.getClass().getResourceAsStream("/vAppTemplate-hosting.xml");
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        VCloudExpressVAppTemplate result = (VCloudExpressVAppTemplate)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(VCloudExpressVAppTemplateHandler.class)).parse(is);
        Assert.assertEquals((Object)result, (Object)new VCloudExpressVAppTemplateImpl("cPanel (Linux) 64 Bit", URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalogItem/4"), "cPanel (Linux) 64 Bit", Status.RESOLVED));
    }
}

