/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.VCloudExpressNetwork;
import org.jclouds.vcloud.domain.network.internal.VCloudExpressNetworkImpl;
import org.jclouds.vcloud.xml.VCloudExpressNetworkHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class VCloudExpressNetworkHandlerTest {
    private Injector injector;
    private ParseSax.Factory factory;

    public void testTerremark() {
        InputStream is = this.getClass().getResourceAsStream("/network-terremark.xml");
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        VCloudExpressNetwork result = (VCloudExpressNetwork)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(VCloudExpressNetworkHandler.class)).parse(is);
        Assert.assertEquals((Object)result, (Object)new VCloudExpressNetworkImpl("10.122.209.128/28", "application/vnd.vmware.vcloud.network+xml", URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.5/network/40031"), null, (Set)ImmutableSet.of(), "10.122.209.129", "255.255.255.240", (Set)ImmutableSet.of((Object)FenceMode.ISOLATED), null, (Set)ImmutableSet.of(), (Set)ImmutableSet.of()));
    }

    public void testHosting() {
        InputStream is = this.getClass().getResourceAsStream("/network-hosting.xml");
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        VCloudExpressNetwork result = (VCloudExpressNetwork)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(VCloudExpressNetworkHandler.class)).parse(is);
        Assert.assertEquals((Object)result, (Object)new VCloudExpressNetworkImpl("188849 trust", null, URI.create("https://vcloud.safesecureweb.com/api/v0.8/network/1183"), "188849 trust", (Set)ImmutableSet.of((Object)"76.12.32.110", (Object)"208.112.89.187"), "204.12.53.89", "255.255.255.248", (Set)ImmutableSet.of(), null, (Set)ImmutableSet.of(), (Set)ImmutableSet.of()));
    }

    public void testBluelock() {
        InputStream is = this.getClass().getResourceAsStream("/network-bluelock.xml");
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        VCloudExpressNetwork result = (VCloudExpressNetwork)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(VCloudExpressNetworkHandler.class)).parse(is);
        Assert.assertEquals((Object)result, (Object)new VCloudExpressNetworkImpl("Pod03_Private", null, URI.create("https://express3.bluelock.com/api/v0.8/network/1"), "Pod 03 Private Network", (Set)ImmutableSet.of((Object)"24.172.173.113", (Object)"66.133.112.131"), "172.18.8.1", "255.255.248.0", (Set)ImmutableSet.of(), null, (Set)ImmutableSet.of(), (Set)ImmutableSet.of()));
    }
}

