/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.options;

import com.google.common.collect.Iterables;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.NetworkConfig;
import org.jclouds.vcloud.options.InstantiateVAppTemplateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class InstantiateVAppTemplateOptionsTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});

    @Test
    public void testAddNetworkConfig() {
        InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
        options.addNetworkConfig(new NetworkConfig("default", URI.create("http://localhost"), FenceMode.BRIDGED));
        Assert.assertEquals((String)((NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getNetworkName(), (String)"default");
        Assert.assertEquals((Object)((NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getParentNetwork(), (Object)URI.create("http://localhost"));
        Assert.assertEquals((Object)((NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getFenceMode(), (Object)FenceMode.BRIDGED);
    }

    @Test
    public void testAddNetworkConfigStatic() {
        InstantiateVAppTemplateOptions options = InstantiateVAppTemplateOptions.Builder.addNetworkConfig((NetworkConfig)new NetworkConfig("default", URI.create("http://localhost"), FenceMode.BRIDGED));
        Assert.assertEquals((String)((NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getNetworkName(), (String)"default");
        Assert.assertEquals((Object)((NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getParentNetwork(), (Object)URI.create("http://localhost"));
        Assert.assertEquals((Object)((NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getFenceMode(), (Object)FenceMode.BRIDGED);
    }

    @Test
    public void testCpuCount() {
        InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
        options.processorCount(3);
        Assert.assertEquals((String)options.getCpuCount(), (String)"3");
    }

    @Test
    public void testCpuCountStatic() {
        InstantiateVAppTemplateOptions options = InstantiateVAppTemplateOptions.Builder.processorCount((int)3);
        Assert.assertEquals((String)options.getCpuCount(), (String)"3");
    }

    @Test
    public void testCustomizeOnInstantiate() {
        InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
        options.customizeOnInstantiate(true);
        Assert.assertEquals((Object)options.shouldCustomizeOnInstantiate(), (Object)new Boolean(true));
    }

    @Test
    public void testCustomizeOnInstantiateStatic() {
        InstantiateVAppTemplateOptions options = InstantiateVAppTemplateOptions.Builder.customizeOnInstantiate((Boolean)true);
        Assert.assertEquals((Object)options.shouldCustomizeOnInstantiate(), (Object)new Boolean(true));
    }

    @Test
    public void testRam() {
        InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
        options.memory(512L);
        Assert.assertEquals((String)options.getMemorySizeMegabytes(), (String)"512");
    }

    @Test
    public void testRamStatic() {
        InstantiateVAppTemplateOptions options = InstantiateVAppTemplateOptions.Builder.memory((int)512);
        Assert.assertEquals((String)options.getMemorySizeMegabytes(), (String)"512");
    }

    @Test
    public void testDisk() {
        InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
        options.disk(512L);
        Assert.assertEquals((String)options.getDiskSizeKilobytes(), (String)"512");
    }

    @Test
    public void testDiskStatic() {
        InstantiateVAppTemplateOptions options = InstantiateVAppTemplateOptions.Builder.disk((long)512L);
        Assert.assertEquals((String)options.getDiskSizeKilobytes(), (String)"512");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDiskStaticWrong() {
        InstantiateVAppTemplateOptions.Builder.disk((long)0L);
    }
}

