/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.IpScope;
import org.jclouds.vcloud.domain.network.VCloudExpressNetwork;
import org.jclouds.vcloud.domain.network.internal.VCloudExpressOrgNetworkAdapter;
import org.jclouds.vcloud.xml.VCloudExpressNetworkHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class VCloudExpressOrgNetworkAdapterTest {
    public void testTerremark() {
        InputStream is = this.getClass().getResourceAsStream("/network-terremark.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        VCloudExpressNetwork in = (VCloudExpressNetwork)factory.create((ParseSax.HandlerWithResult)injector.getInstance(VCloudExpressNetworkHandler.class)).parse(is);
        VCloudExpressOrgNetworkAdapter result = new VCloudExpressOrgNetworkAdapter(in);
        Assert.assertEquals((String)result.getName(), (String)"10.122.209.128/28");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.5/network/40031"));
        Assert.assertEquals((String)result.getType(), (String)"application/vnd.vmware.vcloud.network+xml");
        Assert.assertEquals((Object)result.getOrg(), null);
        Assert.assertEquals((String)result.getDescription(), null);
        Assert.assertEquals((Collection)result.getTasks(), (Collection)ImmutableList.of());
        assert (result.getConfiguration() != null);
        Assert.assertEquals((Object)result.getConfiguration().getIpScope(), (Object)new IpScope(true, "10.122.209.129", "255.255.255.240", null, null, null, (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of()));
        Assert.assertEquals((Object)result.getConfiguration().getParentNetwork(), null);
        Assert.assertEquals((Object)result.getConfiguration().getFenceMode(), (Object)FenceMode.ISOLATED);
        assert (result.getConfiguration().getFeatures() != null);
        Assert.assertEquals((Object)result.getConfiguration().getFeatures().getDhcpService(), null);
        Assert.assertEquals((Object)result.getConfiguration().getFeatures().getFirewallService(), null);
        Assert.assertEquals((Object)result.getConfiguration().getFeatures().getNatService(), null);
        Assert.assertEquals((Object)result.getNetworkPool(), null);
        Assert.assertEquals((Set)result.getAllowedExternalIpAddresses(), (Set)ImmutableSet.of());
    }

    public void testBluelock() {
        InputStream is = this.getClass().getResourceAsStream("/network-bluelock.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        VCloudExpressNetwork in = (VCloudExpressNetwork)factory.create((ParseSax.HandlerWithResult)injector.getInstance(VCloudExpressNetworkHandler.class)).parse(is);
        VCloudExpressOrgNetworkAdapter result = new VCloudExpressOrgNetworkAdapter(in);
        Assert.assertEquals((String)result.getName(), (String)"Pod03_Private");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://express3.bluelock.com/api/v0.8/network/1"));
        Assert.assertEquals((String)result.getType(), null);
        Assert.assertEquals((Object)result.getOrg(), null);
        Assert.assertEquals((String)result.getDescription(), (String)"Pod 03 Private Network");
        Assert.assertEquals((Collection)result.getTasks(), (Collection)ImmutableList.of());
        assert (result.getConfiguration() != null);
        Assert.assertEquals((Object)result.getConfiguration().getIpScope(), (Object)new IpScope(true, "172.18.8.1", "255.255.248.0", "66.133.112.131", "24.172.173.113", null, (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of()));
        Assert.assertEquals((Object)result.getConfiguration().getParentNetwork(), null);
        Assert.assertEquals((Object)result.getConfiguration().getFenceMode(), (Object)FenceMode.BRIDGED);
        assert (result.getConfiguration().getFeatures() != null);
        Assert.assertEquals((Object)result.getConfiguration().getFeatures().getDhcpService(), null);
        Assert.assertEquals((Object)result.getConfiguration().getFeatures().getFirewallService(), null);
        Assert.assertEquals((Object)result.getConfiguration().getFeatures().getNatService(), null);
        Assert.assertEquals((Object)result.getNetworkPool(), null);
        Assert.assertEquals((Set)result.getAllowedExternalIpAddresses(), (Set)ImmutableSet.of());
    }
}

