/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.easymock.classextension.EasyMock;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.Strings2;
import org.jclouds.vcloud.VCloudExpressPropertiesBuilder;
import org.jclouds.vcloud.binders.BindCloneVAppParamsToXmlPayload;
import org.jclouds.vcloud.options.CloneVAppOptions;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class VCloudExpressBindCloneVAppParamsToXmlPayloadTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            Properties props = new Properties();
            Names.bindProperties((Binder)this.binder(), (Properties)((Properties)Preconditions.checkNotNull((Object)new VCloudExpressPropertiesBuilder(props).build(), (Object)"properties")));
        }
    }});

    public void testWithDescriptionDeployOn() throws IOException {
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/cloneVApp.xml"));
        CloneVAppOptions options = new CloneVAppOptions().deploy().powerOn().withDescription("The description of the new vApp");
        GeneratedHttpRequest request = (GeneratedHttpRequest)EasyMock.createMock(GeneratedHttpRequest.class);
        org.easymock.EasyMock.expect((Object)request.getEndpoint()).andReturn((Object)URI.create("http://localhost/key")).anyTimes();
        org.easymock.EasyMock.expect((Object)request.getArgs()).andReturn((Object)ImmutableList.of((Object)options)).atLeastOnce();
        request.setPayload(expected);
        EasyMock.replay((Object[])new Object[]{request});
        BindCloneVAppParamsToXmlPayload binder = (BindCloneVAppParamsToXmlPayload)this.injector.getInstance(BindCloneVAppParamsToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        map.put("newName", "new-linux-server");
        map.put("vApp", "https://vcloud.safesecureweb.com/api/v0.8/vapp/201");
        binder.bindToRequest((HttpRequest)request, (Map)map);
        EasyMock.verify((Object[])new Object[]{request});
    }

    public void testDefault() throws IOException {
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/cloneVApp-default.xml"));
        GeneratedHttpRequest request = (GeneratedHttpRequest)EasyMock.createMock(GeneratedHttpRequest.class);
        org.easymock.EasyMock.expect((Object)request.getEndpoint()).andReturn((Object)URI.create("http://localhost/key")).anyTimes();
        org.easymock.EasyMock.expect((Object)request.getArgs()).andReturn((Object)ImmutableList.of()).atLeastOnce();
        request.setPayload(expected);
        EasyMock.replay((Object[])new Object[]{request});
        BindCloneVAppParamsToXmlPayload binder = (BindCloneVAppParamsToXmlPayload)this.injector.getInstance(BindCloneVAppParamsToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        map.put("newName", "my-vapp");
        map.put("vApp", "https://vcloud.safesecureweb.com/api/v0.8/vapp/4181");
        binder.bindToRequest((HttpRequest)request, (Map)map);
        EasyMock.verify((Object[])new Object[]{request});
    }
}

