/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.inject.Singleton;
import org.easymock.classextension.EasyMock;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.Strings2;
import org.jclouds.vcloud.VCloudExpressPropertiesBuilder;
import org.jclouds.vcloud.binders.BindInstantiateVCloudExpressVAppTemplateParamsToXmlPayload;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.endpoints.Network;
import org.jclouds.vcloud.options.InstantiateVAppTemplateOptions;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindInstantiateVCloudExpressVAppTemplateParamsToXmlPayloadTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            Properties props = new Properties();
            Names.bindProperties((Binder)this.binder(), (Properties)((Properties)Preconditions.checkNotNull((Object)new VCloudExpressPropertiesBuilder(props).build(), (Object)"properties")));
        }

        @Network
        @Provides
        @Singleton
        URI provideNetwork() {
            return URI.create("https://vcloud.safesecureweb.com/network/1990");
        }
    }});

    public void testDefault() throws IOException {
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/newvapp-hosting.xml"));
        GeneratedHttpRequest request = (GeneratedHttpRequest)EasyMock.createMock(GeneratedHttpRequest.class);
        org.easymock.EasyMock.expect((Object)request.getEndpoint()).andReturn((Object)URI.create("http://localhost/key")).anyTimes();
        org.easymock.EasyMock.expect((Object)request.getArgs()).andReturn((Object)ImmutableList.of()).atLeastOnce();
        request.setPayload(expected);
        EasyMock.replay((Object[])new Object[]{request});
        BindInstantiateVCloudExpressVAppTemplateParamsToXmlPayload binder = (BindInstantiateVCloudExpressVAppTemplateParamsToXmlPayload)this.injector.getInstance(BindInstantiateVCloudExpressVAppTemplateParamsToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        map.put("name", "my-vapp");
        map.put("template", "https://vcloud.safesecureweb.com/api/v0.8/vAppTemplate/3");
        binder.bindToRequest((HttpRequest)request, (Map)map);
        EasyMock.verify((Object[])new Object[]{request});
    }

    public void testWithProcessorMemoryDisk() throws IOException {
        InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
        options.processorCount(1).memory(512L).disk(1024L);
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/newvapp-hostingcpumemdisk.xml"));
        GeneratedHttpRequest request = (GeneratedHttpRequest)EasyMock.createMock(GeneratedHttpRequest.class);
        org.easymock.EasyMock.expect((Object)request.getEndpoint()).andReturn((Object)URI.create("http://localhost/key")).anyTimes();
        org.easymock.EasyMock.expect((Object)request.getArgs()).andReturn((Object)ImmutableList.of((Object)options)).atLeastOnce();
        request.setPayload(expected);
        EasyMock.replay((Object[])new Object[]{request});
        BindInstantiateVCloudExpressVAppTemplateParamsToXmlPayload binder = (BindInstantiateVCloudExpressVAppTemplateParamsToXmlPayload)this.injector.getInstance(BindInstantiateVCloudExpressVAppTemplateParamsToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        map.put("name", "my-vapp");
        map.put("template", "https://vcloud.safesecureweb.com/api/v0.8/vAppTemplate/3");
        map.put("network", "https://vcloud.safesecureweb.com/network/1990");
        binder.bindToRequest((HttpRequest)request, (Map)map);
        EasyMock.verify((Object[])new Object[]{request});
    }

    public void testWithNetworkNameDhcpFenceMode() throws IOException {
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/newvapp-hostingnetworknamedhcpfencemode.xml"));
        GeneratedHttpRequest request = (GeneratedHttpRequest)EasyMock.createMock(GeneratedHttpRequest.class);
        org.easymock.EasyMock.expect((Object)request.getEndpoint()).andReturn((Object)URI.create("http://localhost/key")).anyTimes();
        org.easymock.EasyMock.expect((Object)request.getArgs()).andReturn((Object)ImmutableList.of()).atLeastOnce();
        request.setPayload(expected);
        EasyMock.replay((Object[])new Object[]{request});
        BindInstantiateVCloudExpressVAppTemplateParamsToXmlPayload binder = (BindInstantiateVCloudExpressVAppTemplateParamsToXmlPayload)this.injector.getInstance(BindInstantiateVCloudExpressVAppTemplateParamsToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        map.put("name", "my-vapp");
        map.put("template", "https://vcloud.safesecureweb.com/api/v0.8/vAppTemplate/3");
        map.put("network", "https://vcloud.safesecureweb.com/network/1990");
        map.put("networkName", "aloha");
        map.put("fenceMode", FenceMode.BRIDGED.toString());
        binder.bindToRequest((HttpRequest)request, (Map)map);
        EasyMock.verify((Object[])new Object[]{request});
    }
}

