/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud;

import org.jclouds.vcloud.CommonVCloudClientLiveTest;
import org.jclouds.vcloud.VCloudExpressAsyncClient;
import org.jclouds.vcloud.VCloudExpressClient;
import org.jclouds.vcloud.domain.Catalog;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VCloudExpressVApp;
import org.jclouds.vcloud.domain.VDC;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, sequential=true)
public abstract class VCloudExpressClientLiveTest
extends CommonVCloudClientLiveTest<VCloudExpressClient, VCloudExpressAsyncClient> {
    @Test
    public void testGetVAppTemplate() throws Exception {
        Org org = ((VCloudExpressClient)this.connection).findOrgNamed(null);
        for (ReferenceType cat : org.getCatalogs().values()) {
            Catalog response = ((VCloudExpressClient)this.connection).getCatalog(cat.getHref());
            for (ReferenceType resource : response.values()) {
                CatalogItem item;
                if (!resource.getType().equals("application/vnd.vmware.vcloud.catalogItem+xml") || !(item = ((VCloudExpressClient)this.connection).getCatalogItem(resource.getHref())).getEntity().getType().equals("application/vnd.vmware.vcloud.vAppTemplate+xml")) continue;
                Assert.assertNotNull((Object)((VCloudExpressClient)this.connection).getVAppTemplate(item.getEntity().getHref()));
            }
        }
    }

    @Test
    public void testGetVApp() throws Exception {
        Org org = ((VCloudExpressClient)this.connection).findOrgNamed(null);
        for (ReferenceType vdc : org.getVDCs().values()) {
            VDC response = ((VCloudExpressClient)this.connection).getVDC(vdc.getHref());
            for (ReferenceType item : response.getResourceEntities().values()) {
                if (!item.getType().equals("application/vnd.vmware.vcloud.vApp+xml")) continue;
                try {
                    VCloudExpressVApp app = ((VCloudExpressClient)this.connection).getVApp(item.getHref());
                    Assert.assertNotNull((Object)app);
                }
                catch (RuntimeException e) {}
            }
        }
    }

    @Test
    public void testFindVAppTemplate() throws Exception {
        Org org = ((VCloudExpressClient)this.connection).findOrgNamed(null);
        for (ReferenceType cat : org.getCatalogs().values()) {
            Catalog response = ((VCloudExpressClient)this.connection).getCatalog(cat.getHref());
            for (ReferenceType resource : response.values()) {
                CatalogItem item;
                if (!resource.getType().equals("application/vnd.vmware.vcloud.catalogItem+xml") || !(item = ((VCloudExpressClient)this.connection).getCatalogItem(resource.getHref())).getEntity().getType().equals("application/vnd.vmware.vcloud.vAppTemplate+xml")) continue;
                Assert.assertNotNull((Object)((VCloudExpressClient)this.connection).findVAppTemplateInOrgCatalogNamed(org.getName(), response.getName(), item.getEntity().getName()));
            }
        }
    }
}

