/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.RestClientTest;
import org.jclouds.rest.RestContextFactory;
import org.jclouds.rest.RestContextSpec;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.jclouds.util.Strings2;
import org.jclouds.vcloud.CommonVCloudClient;
import org.jclouds.vcloud.VCloudExpressAsyncClient;
import org.jclouds.vcloud.VCloudExpressContextBuilder;
import org.jclouds.vcloud.VCloudExpressLoginAsyncClient;
import org.jclouds.vcloud.VCloudExpressPropertiesBuilder;
import org.jclouds.vcloud.VCloudVersionsAsyncClient;
import org.jclouds.vcloud.config.CommonVCloudRestClientModule;
import org.jclouds.vcloud.config.VCloudExpressRestClientModule;
import org.jclouds.vcloud.domain.Catalog;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VCloudSession;
import org.jclouds.vcloud.domain.VDC;
import org.jclouds.vcloud.domain.internal.CatalogImpl;
import org.jclouds.vcloud.domain.internal.CatalogItemImpl;
import org.jclouds.vcloud.domain.internal.OrgImpl;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.domain.internal.VDCImpl;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.NetworkConfig;
import org.jclouds.vcloud.filters.SetVCloudTokenCookie;
import org.jclouds.vcloud.functions.ParseTaskFromLocationHeader;
import org.jclouds.vcloud.options.CloneVAppOptions;
import org.jclouds.vcloud.options.InstantiateVAppTemplateOptions;
import org.jclouds.vcloud.xml.CatalogItemHandler;
import org.jclouds.vcloud.xml.OrgHandler;
import org.jclouds.vcloud.xml.OrgNetworkFromVCloudExpressNetworkHandler;
import org.jclouds.vcloud.xml.TaskHandler;
import org.jclouds.vcloud.xml.TasksListHandler;
import org.jclouds.vcloud.xml.VCloudExpressCatalogHandler;
import org.jclouds.vcloud.xml.VCloudExpressVAppHandler;
import org.jclouds.vcloud.xml.VCloudExpressVAppTemplateHandler;
import org.jclouds.vcloud.xml.VDCHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VCloudExpressAsyncClientTest")
public class VCloudExpressAsyncClientTest
extends RestClientTest<VCloudExpressAsyncClient> {
    protected String provider = "vcloudexpress";

    public void testInstantiateVAppTemplateInVDCURI() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("instantiateVAppTemplateInVDC", URI.class, URI.class, String.class, InstantiateVAppTemplateOptions[].class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"), URI.create("https://vcloud.safesecureweb.com/api/v0.8/vAppTemplate/3"), "my-vapp"});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/vdc/1/action/instantiateVAppTemplate HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vApp+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/newvapp-hosting.xml")), "application/vnd.vmware.vcloud.instantiateVAppTemplateParams+xml", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VCloudExpressVAppHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testInstantiateVAppTemplateInVDCURIOptions() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("instantiateVAppTemplateInVDC", URI.class, URI.class, String.class, InstantiateVAppTemplateOptions[].class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"), URI.create("https://vcloud.safesecureweb.com/api/v0.8/vAppTemplate/3"), "my-vapp", InstantiateVAppTemplateOptions.Builder.processorCount((int)1).memory(512L).disk(1024L).addNetworkConfig(new NetworkConfig(null, URI.create("https://vcloud.safesecureweb.com/network/1990"), FenceMode.BRIDGED))});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/vdc/1/action/instantiateVAppTemplate HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vApp+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/newvapp-hostingcpumemdisk.xml")), "application/vnd.vmware.vcloud.instantiateVAppTemplateParams+xml", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VCloudExpressVAppHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInstantiateVAppTemplateInOrgOptionsIllegalName() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("instantiateVAppTemplateInVDC", URI.class, URI.class, String.class, InstantiateVAppTemplateOptions[].class);
        this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"), URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"), "CentOS 01", InstantiateVAppTemplateOptions.Builder.processorCount((int)1).memory(512L).disk(1024L).addNetworkConfig(new NetworkConfig("aloha", URI.create("https://vcenterprise.bluelock.com/api/v1.0/network/1990"), null))});
    }

    public void testCloneVAppInVDC() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("cloneVAppInVDC", URI.class, URI.class, String.class, CloneVAppOptions[].class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"), URI.create("https://vcloud.safesecureweb.com/api/v0.8/vapp/4181"), "my-vapp"});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/vdc/1/action/cloneVApp HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/cloneVApp-default.xml")), "application/vnd.vmware.vcloud.cloneVAppParams+xml", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testCloneVAppInVDCOptions() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("cloneVAppInVDC", URI.class, URI.class, String.class, CloneVAppOptions[].class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"), URI.create("https://vcloud.safesecureweb.com/api/v0.8/vapp/201"), "new-linux-server", new CloneVAppOptions().deploy().powerOn().withDescription("The description of the new vApp")});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/vdc/1/action/cloneVApp HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/cloneVApp.xml")), "application/vnd.vmware.vcloud.cloneVAppParams+xml", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testOrg() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("getOrg", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/org/1")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/org/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.org+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, OrgHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testFindOrgNamed() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("findOrgNamed", String.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{"org"});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/org/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.org+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, OrgHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCatalog() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("getCatalog", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalog/1")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/catalog/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.catalog+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VCloudExpressCatalogHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCatalogInOrg() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("findCatalogInOrgNamed", String.class, String.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{"org", "catalog"});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/catalog/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.catalog+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VCloudExpressCatalogHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testNetwork() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("getNetwork", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/network/2")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/network/2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.network+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, OrgNetworkFromVCloudExpressNetworkHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCatalogItemURI() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("getCatalogItem", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalogItem/2")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/catalogItem/2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.catalogItem+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, CatalogItemHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testFindCatalogItemInOrgCatalogNamed() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("findCatalogItemInOrgCatalogNamed", String.class, String.class, String.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{"org", "catalog", "item"});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/catalogItem/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.catalogItem+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, CatalogItemHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testFindVAppTemplate() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("findVAppTemplateInOrgCatalogNamed", String.class, String.class, String.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{"org", "catalog", "template"});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/vAppTemplate/2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vAppTemplate+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VCloudExpressVAppTemplateHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testVAppTemplateURI() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("getVAppTemplate", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vAppTemplate/2")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/vAppTemplate/2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vAppTemplate+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VCloudExpressVAppTemplateHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testFindVDCInOrgNamed() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("findVDCInOrgNamed", String.class, String.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{"org", "vdc"});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/vdc/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vdc+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VDCHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testFindVDCInOrgNamedBadVDC() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("findVDCInOrgNamed", String.class, String.class);
        this.processor.createRequest(method, new Object[]{"org", "vdc1"});
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testFindVDCInOrgNamedBadOrg() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("findVDCInOrgNamed", String.class, String.class);
        this.processor.createRequest(method, new Object[]{"org1", "vdc"});
    }

    public void testFindVDCInOrgNamedNullOrg() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("findVDCInOrgNamed", String.class, String.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{null, "vdc"});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/vdc/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vdc+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VDCHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testFindVDCInOrgNamedNullOrgAndVDC() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("findVDCInOrgNamed", String.class, String.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{null, null});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/vdc/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vdc+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VDCHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetVDC() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("getVDC", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/vdc/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vdc+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VDCHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetTasksList() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("getTasksList", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/tasksList/1")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/tasksList/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.tasksList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TasksListHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testFindTasksListInOrgNamed() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("findTasksListInOrgNamed", String.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{"org"});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/tasksList/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.tasksList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TasksListHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeployVApp() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("deployVApp", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vApp/1")});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/vApp/1/action/deploy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testGet() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("getVApp", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vApp/1")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/vApp/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vApp+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VCloudExpressVAppHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testUndeployVApp() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("undeployVApp", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vApp/1")});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/vApp/1/action/undeploy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testDelete() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("deleteVApp", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vApp/1")});
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://vcloud.safesecureweb.com/api/v0.8/vApp/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseTaskFromLocationHeader.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testPowerOnVApp() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("powerOnVApp", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vApp/1")});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/vApp/1/power/action/powerOn HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testPowerOffVApp() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("powerOffVApp", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vApp/1")});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/vApp/1/power/action/powerOff HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testResetVApp() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("resetVApp", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vApp/1")});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/vApp/1/power/action/reset HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testSuspendVApp() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("suspendVApp", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vApp/1")});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/vApp/1/power/action/suspend HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testShutdownVApp() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("shutdownVApp", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vApp/1")});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/vApp/1/power/action/shutdown HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetTask() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("getTask", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/task/1")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/task/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCancelTask() throws SecurityException, NoSuchMethodException, IOException {
        Method method = VCloudExpressAsyncClient.class.getMethod("cancelTask", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/task/1")});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/task/1/action/cancel HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), SetVCloudTokenCookie.class);
    }

    protected TypeLiteral<RestAnnotationProcessor<VCloudExpressAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<VCloudExpressAsyncClient>>(){};
    }

    protected Module createModule() {
        return new VCloudRestClientModuleExtension();
    }

    protected Properties getProperties() {
        Properties overrides = new Properties();
        overrides.setProperty(this.provider + ".endpoint", "https://vcloud.safesecureweb.com/api/v0.8");
        overrides.setProperty(this.provider + ".propertiesbuilder", VCloudExpressPropertiesBuilder.class.getName());
        overrides.setProperty(this.provider + ".contextbuilder", VCloudExpressContextBuilder.class.getName());
        return overrides;
    }

    public RestContextSpec<?, ?> createContextSpec() {
        return new RestContextFactory(this.getProperties()).createContextSpec(this.provider, "identity", "credential", new Properties());
    }

    @RequiresHttp
    @ConfiguresRestClient
    public static class VCloudRestClientModuleExtension
    extends VCloudExpressRestClientModule {
        protected URI provideAuthenticationURI(VCloudVersionsAsyncClient versionService, @Named(value="jclouds.api-version") String version) {
            return URI.create("https://vcloud.safesecureweb.com/api/v0.8/login");
        }

        protected URI provideOrg(@org.jclouds.vcloud.endpoints.Org Iterable<ReferenceType> orgs) {
            return URI.create("https://vcloud.safesecureweb.com/api/v0.8/org");
        }

        protected String provideOrgName(@org.jclouds.vcloud.endpoints.Org Iterable<ReferenceType> orgs) {
            return "org";
        }

        protected URI provideCatalog(Org org, @Named(value="jclouds.identity") String user, CommonVCloudRestClientModule.WriteableCatalog write) {
            return URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalog");
        }

        protected Org provideOrg(CommonVCloudClient discovery) {
            return null;
        }

        protected Iterable<ReferenceType> provideOrgs(Supplier<VCloudSession> cache, @Named(value="jclouds.identity") String user) {
            return null;
        }

        protected URI provideDefaultTasksList(Org org) {
            return URI.create("https://vcloud.safesecureweb.com/api/v0.8/taskslist");
        }

        protected URI provideDefaultVDC(Org org, @org.jclouds.vcloud.endpoints.VDC String defaultVDC) {
            return URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1");
        }

        protected String provideDefaultVDCName(@org.jclouds.vcloud.endpoints.VDC Supplier<Map<String, String>> vDCtoOrgSupplier) {
            return "vdc";
        }

        protected URI provideDefaultNetwork(URI vdc, Injector injector) {
            return URI.create("https://vcloud.safesecureweb.com/network/1990");
        }

        protected Supplier<VCloudSession> provideVCloudTokenCache(@Named(value="jclouds.session-interval") long seconds, VCloudExpressLoginAsyncClient login) {
            return Suppliers.ofInstance((Object)new VCloudSession(){

                public Map<String, ReferenceType> getOrgs() {
                    return ImmutableMap.of((Object)"org", (Object)new ReferenceTypeImpl("org", "application/vnd.vmware.vcloud.org+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/org/1")));
                }

                public String getVCloudToken() {
                    return "token";
                }
            });
        }

        protected void configure() {
            super.configure();
            this.bind(CommonVCloudRestClientModule.OrgMapSupplier.class).to(TestOrgMapSupplier.class);
            this.bind(CommonVCloudRestClientModule.OrgCatalogSupplier.class).to(TestOrgCatalogSupplier.class);
            this.bind(CommonVCloudRestClientModule.OrgCatalogItemSupplier.class).to(TestOrgCatalogItemSupplier.class);
        }

        protected Supplier<Map<String, Map<String, ? extends VDC>>> provideOrgVDCSupplierCache(@Named(value="jclouds.session-interval") long seconds, CommonVCloudRestClientModule.OrgVDCSupplier supplier) {
            return Suppliers.ofInstance((Object)ImmutableMap.of((Object)"org", (Object)ImmutableMap.of((Object)"vdc", (Object)new VDCImpl("vdc", null, URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"), null, null, "description", null, null, null, null, null, (Map)ImmutableMap.of((Object)"vapp", (Object)new ReferenceTypeImpl("vapp", "application/vnd.vmware.vcloud.vApp+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vApp/188849-1")), (Object)"network", (Object)new ReferenceTypeImpl("network", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdcItem/2"))), null, 0, 0, 0, false))));
        }

        @Singleton
        public static class TestOrgCatalogItemSupplier
        extends CommonVCloudRestClientModule.OrgCatalogItemSupplier {
            protected TestOrgCatalogItemSupplier() {
                super(null, null);
            }

            public Map<String, Map<String, Map<String, ? extends CatalogItem>>> get() {
                return ImmutableMap.of((Object)"org", (Object)ImmutableMap.of((Object)"catalog", (Object)ImmutableMap.of((Object)"template", (Object)new CatalogItemImpl("template", URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalogItem/2"), "description", (ReferenceType)new ReferenceTypeImpl("template", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vAppTemplate/2")), (Map)ImmutableMap.of()))));
            }
        }

        @Singleton
        public static class TestOrgCatalogSupplier
        extends CommonVCloudRestClientModule.OrgCatalogSupplier {
            @Inject
            protected TestOrgCatalogSupplier() {
                super(null, null);
            }

            public Map<String, Map<String, ? extends Catalog>> get() {
                return ImmutableMap.of((Object)"org", (Object)ImmutableMap.of((Object)"catalog", (Object)new CatalogImpl("catalog", "type", URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalog/1"), null, "description", (Map)ImmutableMap.of((Object)"item", (Object)new ReferenceTypeImpl("item", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalogItem/1")), (Object)"template", (Object)new ReferenceTypeImpl("template", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalogItem/2"))), (Iterable)ImmutableList.of(), true, false)));
            }
        }

        @Singleton
        public static class TestOrgMapSupplier
        extends CommonVCloudRestClientModule.OrgMapSupplier {
            @Inject
            protected TestOrgMapSupplier() {
                super(null, null);
            }

            public Map<String, Org> get() {
                return ImmutableMap.of((Object)"org", (Object)new OrgImpl("org", null, URI.create("https://vcloud.safesecureweb.com/api/v0.8/org/1"), "org", null, (Map)ImmutableMap.of((Object)"catalog", (Object)new ReferenceTypeImpl("catalog", "application/vnd.vmware.vcloud.catalog+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalog/1"))), (Map)ImmutableMap.of((Object)"vdc", (Object)new ReferenceTypeImpl("vdc", "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"))), (Map)ImmutableMap.of(), (ReferenceType)new ReferenceTypeImpl("tasksList", "application/vnd.vmware.vcloud.tasksList+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/tasksList/1")), (Iterable)ImmutableList.of()));
            }
        }
    }
}

