/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network.internal;

import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Set;
import javax.annotation.Nullable;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.VCloudExpressNetwork;
import org.jclouds.vcloud.domain.network.firewall.FirewallRule;
import org.jclouds.vcloud.domain.network.nat.rules.PortForwardingRule;

public class VCloudExpressNetworkImpl
extends ReferenceTypeImpl
implements VCloudExpressNetwork {
    private static final long serialVersionUID = 8464716396538298809L;
    protected final String description;
    protected final Set<String> dnsServers = Sets.newHashSet();
    protected final String gateway;
    protected final String netmask;
    protected final Set<FenceMode> fenceModes = Sets.newHashSet();
    @Nullable
    protected final Boolean dhcp;
    protected final Set<PortForwardingRule> natRules = Sets.newHashSet();
    protected final Set<FirewallRule> firewallRules = Sets.newHashSet();

    public VCloudExpressNetworkImpl(String name, String type, URI id, String description, Set<String> dnsServers, String gateway, String netmask, Set<FenceMode> fenceModes, Boolean dhcp, Set<PortForwardingRule> natRules, Set<FirewallRule> firewallRules) {
        super(name, type, id);
        this.description = description;
        this.dnsServers.addAll(dnsServers);
        this.gateway = gateway;
        this.netmask = netmask;
        this.fenceModes.addAll(fenceModes);
        this.dhcp = dhcp;
        this.natRules.addAll(natRules);
        this.firewallRules.addAll(firewallRules);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Set<String> getDnsServers() {
        return this.dnsServers;
    }

    @Override
    public String getGateway() {
        return this.gateway;
    }

    @Override
    public String getNetmask() {
        return this.netmask;
    }

    @Override
    public Set<FenceMode> getFenceModes() {
        return this.fenceModes;
    }

    @Override
    public Boolean isDhcp() {
        return this.dhcp;
    }

    @Override
    public Set<PortForwardingRule> getNatRules() {
        return this.natRules;
    }

    @Override
    public Set<FirewallRule> getFirewallRules() {
        return this.firewallRules;
    }

    public int compareTo(ReferenceType o) {
        return this == o ? 0 : this.getHref().compareTo(o.getHref());
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.dhcp == null ? 0 : this.dhcp.hashCode());
        result = 31 * result + (this.dnsServers == null ? 0 : ((Object)this.dnsServers).hashCode());
        result = 31 * result + (this.fenceModes == null ? 0 : ((Object)this.fenceModes).hashCode());
        result = 31 * result + (this.firewallRules == null ? 0 : ((Object)this.firewallRules).hashCode());
        result = 31 * result + (this.gateway == null ? 0 : this.gateway.hashCode());
        result = 31 * result + (this.natRules == null ? 0 : ((Object)this.natRules).hashCode());
        result = 31 * result + (this.netmask == null ? 0 : this.netmask.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VCloudExpressNetworkImpl other = (VCloudExpressNetworkImpl)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.dhcp == null ? other.dhcp != null : !this.dhcp.equals(other.dhcp)) {
            return false;
        }
        if (this.dnsServers == null ? other.dnsServers != null : !((Object)this.dnsServers).equals(other.dnsServers)) {
            return false;
        }
        if (this.fenceModes == null ? other.fenceModes != null : !((Object)this.fenceModes).equals(other.fenceModes)) {
            return false;
        }
        if (this.firewallRules == null ? other.firewallRules != null : !((Object)this.firewallRules).equals(other.firewallRules)) {
            return false;
        }
        if (this.gateway == null ? other.gateway != null : !this.gateway.equals(other.gateway)) {
            return false;
        }
        if (this.natRules == null ? other.natRules != null : !((Object)this.natRules).equals(other.natRules)) {
            return false;
        }
        return !(this.netmask == null ? other.netmask != null : !this.netmask.equals(other.netmask));
    }

    public String toString() {
        return "[id=" + this.getHref() + ", name=" + this.getName() + ", type=" + this.getType() + ", description=" + this.description + ", dhcp=" + this.dhcp + ", dnsServers=" + this.dnsServers + ", fenceModes=" + this.fenceModes + ", firewallRules=" + this.firewallRules + ", gateway=" + this.gateway + ", natRules=" + this.natRules + ", netmask=" + this.netmask + "]";
    }
}

