/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import java.net.URI;
import java.util.Set;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.VCloudExpressVApp;
import org.jclouds.vcloud.domain.ovf.ResourceAllocation;
import org.jclouds.vcloud.domain.ovf.System;

public class VCloudExpressVAppImpl
implements VCloudExpressVApp {
    private final String name;
    private final URI href;
    private final ReferenceType vDC;
    private final Status status;
    private final Long size;
    private final ListMultimap<String, String> networkToAddresses;
    private final String operatingSystemDescription;
    private final System system;
    private final Set<ResourceAllocation> resourceAllocations;
    private final Integer osType;
    private static final long serialVersionUID = 8464716396538298809L;

    public VCloudExpressVAppImpl(String name, URI href, Status status, Long size, ReferenceType vDC, ListMultimap<String, String> networkToAddresses, Integer osType, String operatingSystemDescription, System system, Set<ResourceAllocation> resourceAllocations) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.href = (URI)Preconditions.checkNotNull((Object)href, (Object)"href");
        this.status = (Status)Preconditions.checkNotNull((Object)status, (Object)"status");
        this.size = size;
        this.vDC = vDC;
        this.networkToAddresses = (ListMultimap)Preconditions.checkNotNull(networkToAddresses, (Object)"networkToAddresses");
        this.osType = osType;
        this.operatingSystemDescription = operatingSystemDescription;
        this.system = system;
        this.resourceAllocations = (Set)Preconditions.checkNotNull(resourceAllocations, (Object)"resourceAllocations");
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public ListMultimap<String, String> getNetworkToAddresses() {
        return this.networkToAddresses;
    }

    @Override
    public Integer getOsType() {
        return this.osType;
    }

    @Override
    public String getOperatingSystemDescription() {
        return this.operatingSystemDescription;
    }

    @Override
    public System getSystem() {
        return this.system;
    }

    @Override
    public Set<ResourceAllocation> getResourceAllocations() {
        return this.resourceAllocations;
    }

    @Override
    public ReferenceType getVDC() {
        return this.vDC;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.networkToAddresses == null ? 0 : this.networkToAddresses.hashCode());
        result = 31 * result + (this.operatingSystemDescription == null ? 0 : this.operatingSystemDescription.hashCode());
        result = 31 * result + (this.resourceAllocations == null ? 0 : ((Object)this.resourceAllocations).hashCode());
        result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
        result = 31 * result + (this.osType == null ? 0 : this.osType.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.system == null ? 0 : this.system.hashCode());
        result = 31 * result + (this.vDC == null ? 0 : this.vDC.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VCloudExpressVAppImpl other = (VCloudExpressVAppImpl)obj;
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.osType == null ? other.osType != null : !this.osType.equals(other.osType)) {
            return false;
        }
        if (this.networkToAddresses == null ? other.networkToAddresses != null : !this.networkToAddresses.equals(other.networkToAddresses)) {
            return false;
        }
        if (this.operatingSystemDescription == null ? other.operatingSystemDescription != null : !this.operatingSystemDescription.equals(other.operatingSystemDescription)) {
            return false;
        }
        if (this.resourceAllocations == null ? other.resourceAllocations != null : !((Object)this.resourceAllocations).equals(other.resourceAllocations)) {
            return false;
        }
        if (this.size == null ? other.size != null : !this.size.equals(other.size)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals((Object)other.status)) {
            return false;
        }
        if (this.system == null ? other.system != null : !this.system.equals((Object)other.system)) {
            return false;
        }
        return !(this.vDC == null ? other.vDC != null : !this.vDC.equals(other.vDC));
    }

    public String getName() {
        return this.name;
    }

    public URI getHref() {
        return this.href;
    }

    @Override
    public Long getSize() {
        return this.size;
    }

    public String toString() {
        return "[href=" + this.href + ", name=" + this.name + ", networkToAddresses=" + this.networkToAddresses + ", osType=" + this.osType + ", operatingSystemDescription=" + this.operatingSystemDescription + ", resourceAllocationByType=" + this.resourceAllocations + ", size=" + this.size + ", status=" + this.status + ", system=" + this.system + ", vDC=" + this.vDC + "]";
    }

    public String getType() {
        return "application/vnd.vmware.vcloud.vApp+xml";
    }

    public int compareTo(ReferenceType o) {
        return this == o ? 0 : this.getHref().compareTo(o.getHref());
    }
}

