/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.strategy;

import com.google.common.base.Preconditions;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.vcloud.compute.CommonVCloudComputeClient;

@Singleton
public class VCloudExpressDestroyNodeStrategy
implements DestroyNodeStrategy {
    protected final CommonVCloudComputeClient computeClient;
    protected final GetNodeMetadataStrategy getNode;

    @Inject
    protected VCloudExpressDestroyNodeStrategy(CommonVCloudComputeClient computeClient, GetNodeMetadataStrategy getNode) {
        this.computeClient = computeClient;
        this.getNode = getNode;
    }

    public NodeMetadata destroyNode(String id) {
        this.computeClient.stop(URI.create((String)Preconditions.checkNotNull((Object)id, (Object)"node.id")));
        return this.getNode.getNode(id);
    }
}

