/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.vcloud.CommonVCloudClient;
import org.jclouds.vcloud.VCloudExpressClient;
import org.jclouds.vcloud.compute.VCloudExpressComputeClient;
import org.jclouds.vcloud.compute.internal.CommonVCloudComputeClientImpl;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.VCloudExpressVApp;
import org.jclouds.vcloud.domain.VCloudExpressVAppTemplate;
import org.jclouds.vcloud.options.InstantiateVAppTemplateOptions;

@Singleton
public class VCloudExpressComputeClientImpl
extends CommonVCloudComputeClientImpl<VCloudExpressVAppTemplate, VCloudExpressVApp>
implements VCloudExpressComputeClient {
    protected final Map<Status, NodeState> vAppStatusToNodeState;

    @Inject
    public VCloudExpressComputeClientImpl(VCloudExpressClient client, Predicate<URI> successTester, Map<Status, NodeState> vAppStatusToNodeState) {
        super((CommonVCloudClient)client, successTester);
        this.vAppStatusToNodeState = vAppStatusToNodeState;
    }

    protected void deleteVApp(VCloudExpressVApp vApp) {
        this.logger.debug(">> deleting vApp(%s)", new Object[]{vApp.getName()});
        ((VCloudExpressClient)VCloudExpressClient.class.cast(this.client)).deleteVApp(vApp.getHref());
    }

    @Override
    public VCloudExpressVApp start(@Nullable URI VDC2, URI templateId, String name, InstantiateVAppTemplateOptions options, int ... portsToOpen) {
        Preconditions.checkNotNull((Object)options, (Object)"options");
        this.logger.debug(">> instantiating vApp vDC(%s) template(%s) name(%s) options(%s) ", new Object[]{VDC2, templateId, name, options});
        VCloudExpressVApp vAppResponse = ((VCloudExpressClient)VCloudExpressClient.class.cast(this.client)).instantiateVAppTemplateInVDC(VDC2, templateId, name, options);
        this.logger.debug("<< instantiated VApp(%s)", new Object[]{vAppResponse.getName()});
        if (options.shouldDeploy()) {
            this.logger.debug(">> deploying vApp(%s)", new Object[]{vAppResponse.getName()});
            Task task = ((VCloudExpressClient)VCloudExpressClient.class.cast(this.client)).deployVApp(vAppResponse.getHref());
            if (options.shouldBlock()) {
                if (!this.taskTester.apply((Object)task.getHref())) {
                    throw new RuntimeException(String.format("failed to %s %s: %s", "deploy", vAppResponse.getName(), task));
                }
                this.logger.debug("<< deployed vApp(%s)", new Object[]{vAppResponse.getName()});
                if (options.shouldPowerOn()) {
                    this.logger.debug(">> powering vApp(%s)", new Object[]{vAppResponse.getName()});
                    task = ((VCloudExpressClient)VCloudExpressClient.class.cast(this.client)).powerOnVApp(vAppResponse.getHref());
                    if (!this.taskTester.apply((Object)task.getHref())) {
                        throw new RuntimeException(String.format("failed to %s %s: %s", "powerOn", vAppResponse.getName(), task));
                    }
                    this.logger.debug("<< on vApp(%s)", new Object[]{vAppResponse.getName()});
                }
            }
        }
        return vAppResponse;
    }

    public Set<String> getPrivateAddresses(URI id) {
        return ImmutableSet.of();
    }

    public Set<String> getPublicAddresses(URI id) {
        VCloudExpressVApp vApp = this.refreshVApp(id);
        return Sets.newHashSet((Iterable)vApp.getNetworkToAddresses().values());
    }

    protected Status getStatus(VCloudExpressVApp vApp) {
        return vApp.getStatus();
    }

    protected VCloudExpressVApp refreshVApp(URI id) {
        return ((VCloudExpressClient)VCloudExpressClient.class.cast(this.client)).getVApp(id);
    }

    protected Task powerOff(VCloudExpressVApp vApp) {
        return ((VCloudExpressClient)VCloudExpressClient.class.cast(this.client)).powerOffVApp(vApp.getHref());
    }

    protected Task reset(VCloudExpressVApp vApp) {
        return ((VCloudExpressClient)VCloudExpressClient.class.cast(this.client)).resetVApp(vApp.getHref());
    }

    protected Task undeploy(VCloudExpressVApp vApp) {
        return ((VCloudExpressClient)VCloudExpressClient.class.cast(this.client)).undeployVApp(vApp.getHref());
    }
}

