/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.vcloud.compute.functions.FindLocationForResource;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VCloudExpressVAppTemplate;

public class ImageForVCloudExpressVAppTemplate
implements Function<VCloudExpressVAppTemplate, Image> {
    private final FindLocationForResource findLocationForResource;
    private final PopulateDefaultLoginCredentialsForImageStrategy credentialsProvider;
    private final Function<String, OperatingSystem> osParser;
    private ReferenceType parent;

    @Inject
    protected ImageForVCloudExpressVAppTemplate(FindLocationForResource findLocationForResource, PopulateDefaultLoginCredentialsForImageStrategy credentialsProvider, Function<String, OperatingSystem> osParser) {
        this.findLocationForResource = (FindLocationForResource)Preconditions.checkNotNull((Object)findLocationForResource, (Object)"findLocationForResource");
        this.credentialsProvider = (PopulateDefaultLoginCredentialsForImageStrategy)Preconditions.checkNotNull((Object)credentialsProvider, (Object)"credentialsProvider");
        this.osParser = osParser;
    }

    public ImageForVCloudExpressVAppTemplate withParent(ReferenceType parent) {
        this.parent = parent;
        return this;
    }

    public Image apply(VCloudExpressVAppTemplate from) {
        ImageBuilder builder = new ImageBuilder();
        builder.ids(from.getHref().toASCIIString());
        builder.uri(from.getHref());
        builder.name(from.getName());
        builder.location(this.findLocationForResource.apply((ReferenceType)Preconditions.checkNotNull((Object)this.parent, (Object)"parent")));
        builder.description(from.getDescription() != null ? from.getDescription() : from.getName());
        builder.operatingSystem((OperatingSystem)this.osParser.apply((Object)from.getName()));
        builder.defaultCredentials(this.credentialsProvider.execute((Object)from));
        return builder.build();
    }
}

