/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.predicates.ImagePredicates;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.compute.functions.FindLocationForResource;
import org.jclouds.vcloud.compute.functions.ResourceAllocationsToVolumes;
import org.jclouds.vcloud.domain.VCloudExpressVApp;
import org.jclouds.vcloud.domain.ovf.ResourceAllocation;
import org.jclouds.vcloud.domain.ovf.ResourceType;
import org.jclouds.vcloud.predicates.VCloudPredicates;

public class HardwareForVCloudExpressVApp
implements Function<VCloudExpressVApp, Hardware> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final FindLocationForResource findLocationForResource;
    private final ResourceAllocationsToVolumes resourceAllocationsToVolumes;

    @Inject
    protected HardwareForVCloudExpressVApp(FindLocationForResource findLocationForResource, ResourceAllocationsToVolumes resourceAllocationsToVolumes) {
        this.findLocationForResource = (FindLocationForResource)Preconditions.checkNotNull((Object)findLocationForResource, (Object)"findLocationForResource");
        this.resourceAllocationsToVolumes = (ResourceAllocationsToVolumes)Preconditions.checkNotNull((Object)resourceAllocationsToVolumes, (Object)"resourceAllocationsToVolumes");
    }

    public Hardware apply(VCloudExpressVApp from) {
        Preconditions.checkNotNull((Object)from, (Object)"VApp");
        Location location = this.findLocationForResource.apply(((VCloudExpressVApp)Preconditions.checkNotNull((Object)from, (Object)"from")).getVDC());
        try {
            int ram = (int)((ResourceAllocation)Iterables.find(from.getResourceAllocations(), (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.MEMORY))).getVirtualQuantity();
            ArrayList processors = Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.filter(from.getResourceAllocations(), (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.PROCESSOR)), (Function)new Function<ResourceAllocation, Processor>(){

                public Processor apply(ResourceAllocation arg0) {
                    return new Processor((double)arg0.getVirtualQuantity(), 1.0);
                }
            }));
            ArrayList volumes = Lists.newArrayList(this.resourceAllocationsToVolumes.apply(from.getResourceAllocations()));
            return new HardwareBuilder().ids(from.getHref().toASCIIString()).name(from.getName()).location(location).processors((List)processors).ram(ram).volumes((List)volumes).supportsImage(ImagePredicates.idEquals((String)from.getHref().toASCIIString())).build();
        }
        catch (NoSuchElementException e) {
            this.logger.debug("incomplete data to form vApp %s", new Object[]{from.getHref()});
            return null;
        }
    }
}

