/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.jamesmurty.utils.XMLBuilder;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.vcloud.domain.network.NetworkConfig;
import org.jclouds.vcloud.domain.ovf.ResourceType;
import org.jclouds.vcloud.endpoints.Network;
import org.jclouds.vcloud.options.InstantiateVAppTemplateOptions;

@Singleton
public class BindInstantiateVCloudExpressVAppTemplateParamsToXmlPayload
implements MapBinder {
    protected final String ns;
    protected final String schema;
    private final BindToStringPayload stringBinder;
    protected final Map<ResourceType, String> virtualHardwareToInstanceId = ImmutableMap.of((Object)ResourceType.PROCESSOR, (Object)"1", (Object)ResourceType.MEMORY, (Object)"2", (Object)ResourceType.DISK_DRIVE, (Object)"9");
    private final URI defaultNetwork;
    private final String defaultFenceMode;
    private final String apiVersion;

    @Inject
    public BindInstantiateVCloudExpressVAppTemplateParamsToXmlPayload(BindToStringPayload stringBinder, @Named(value="jclouds.api-version") String apiVersion, @Named(value="jclouds.vcloud.xml.ns") String ns, @Named(value="jclouds.vcloud.xml.schema") String schema, @Network URI network, @Named(value="jclouds.vcloud.defaults.fencemode") String fenceMode) {
        this.ns = ns;
        this.apiVersion = apiVersion;
        this.schema = schema;
        this.stringBinder = stringBinder;
        this.defaultNetwork = network;
        this.defaultFenceMode = fenceMode;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, String> postParams) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull(request, (Object)"request") instanceof GeneratedHttpRequest), (Object)"this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        Preconditions.checkState((gRequest.getArgs() != null ? 1 : 0) != 0, (Object)"args should be initialized at this point");
        String name = (String)Preconditions.checkNotNull((Object)postParams.remove("name"), (Object)"name");
        String template = (String)Preconditions.checkNotNull((Object)postParams.remove("template"), (Object)"template");
        TreeMap virtualHardwareQuantity = Maps.newTreeMap();
        InstantiateVAppTemplateOptions options = this.findOptionsInArgsOrNull(gRequest);
        String network = this.defaultNetwork != null ? this.defaultNetwork.toASCIIString() : null;
        String fenceMode = this.defaultFenceMode;
        String networkName = name;
        if (options != null) {
            if (options.getNetworkConfig().size() > 0) {
                NetworkConfig config = (NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0);
                network = this.ifNullDefaultTo(config.getParentNetwork(), network);
                fenceMode = this.ifNullDefaultTo(config.getFenceMode(), this.defaultFenceMode);
                if (this.apiVersion.indexOf("0.8") != -1 && fenceMode.equals("bridged")) {
                    fenceMode = "allowInOut";
                }
                networkName = this.ifNullDefaultTo(config.getNetworkName(), networkName);
            }
            this.addQuantity(options, virtualHardwareQuantity);
        }
        try {
            return (R)this.stringBinder.bindToRequest(request, (Object)this.generateXml(name, template, virtualHardwareQuantity, networkName, fenceMode, URI.create(network)));
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    protected String generateXml(String name, String template, SortedMap<ResourceType, String> virtualHardwareQuantity, String networkName, @Nullable String fenceMode, URI network) throws ParserConfigurationException, FactoryConfigurationError, TransformerException {
        XMLBuilder rootBuilder = this.buildRoot(name);
        rootBuilder.e("VAppTemplate").a("href", template);
        XMLBuilder instantiationParamsBuilder = rootBuilder.e("InstantiationParams");
        this.addVirtualQuantityIfPresent(instantiationParamsBuilder, virtualHardwareQuantity);
        this.addNetworkConfig(instantiationParamsBuilder, networkName, fenceMode, network);
        Properties outputProperties = new Properties();
        outputProperties.put("omit-xml-declaration", "yes");
        return rootBuilder.asString(outputProperties);
    }

    protected void addNetworkConfig(XMLBuilder instantiationParamsBuilder, String name, @Nullable String fenceMode, URI network) {
        XMLBuilder networkConfigBuilder = instantiationParamsBuilder.e("NetworkConfigSection").e("NetworkConfig").a("name", name);
        if (fenceMode != null) {
            XMLBuilder featuresBuilder = networkConfigBuilder.e("Features");
            featuresBuilder.e("FenceMode").t(fenceMode);
        }
        networkConfigBuilder.e("NetworkAssociation").a("href", network.toASCIIString());
    }

    protected void addVirtualQuantityIfPresent(XMLBuilder instantiationParamsBuilder, SortedMap<ResourceType, String> virtualHardwareQuantity) {
        if (virtualHardwareQuantity.size() > 0) {
            XMLBuilder virtualHardwareSectionBuilder = instantiationParamsBuilder.e("VirtualHardwareSection").a("xmlns:q1", this.ns);
            for (Map.Entry<ResourceType, String> entry : virtualHardwareQuantity.entrySet()) {
                XMLBuilder itemBuilder = virtualHardwareSectionBuilder.e("Item").a("xmlns", "http://schemas.dmtf.org/ovf/envelope/1");
                itemBuilder.e("InstanceID").a("xmlns", "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData").t(this.virtualHardwareToInstanceId.get(entry.getKey()));
                itemBuilder.e("ResourceType").a("xmlns", "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData").t(entry.getKey().value());
                itemBuilder.e("VirtualQuantity").a("xmlns", "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData").t(entry.getValue());
            }
        }
    }

    protected XMLBuilder buildRoot(String name) throws ParserConfigurationException, FactoryConfigurationError {
        XMLBuilder rootBuilder = XMLBuilder.create((String)"InstantiateVAppTemplateParams").a("name", name).a("xmlns", this.ns).a("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance").a("xsi:schemaLocation", this.ns + " " + this.schema).a("xmlns:ovf", "http://schemas.dmtf.org/ovf/envelope/1");
        return rootBuilder;
    }

    protected InstantiateVAppTemplateOptions findOptionsInArgsOrNull(GeneratedHttpRequest<?> gRequest) {
        for (Object arg : gRequest.getArgs()) {
            if (arg instanceof InstantiateVAppTemplateOptions) {
                return (InstantiateVAppTemplateOptions)arg;
            }
            if (!(arg instanceof InstantiateVAppTemplateOptions[])) continue;
            InstantiateVAppTemplateOptions[] options = (InstantiateVAppTemplateOptions[])arg;
            return options.length > 0 ? options[0] : null;
        }
        return null;
    }

    private void addQuantity(InstantiateVAppTemplateOptions options, Map<ResourceType, String> virtualHardwareQuantity) {
        if (options.getCpuCount() != null) {
            virtualHardwareQuantity.put(ResourceType.PROCESSOR, options.getCpuCount());
        }
        if (options.getMemorySizeMegabytes() != null) {
            virtualHardwareQuantity.put(ResourceType.MEMORY, options.getMemorySizeMegabytes());
        }
        if (options.getDiskSizeKilobytes() != null) {
            virtualHardwareQuantity.put(ResourceType.DISK_DRIVE, options.getDiskSizeKilobytes());
        }
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new IllegalStateException("InstantiateVAppTemplateParams is needs parameters");
    }

    protected String ifNullDefaultTo(Object value, String defaultValue) {
        return value != null ? value.toString() : (String)Preconditions.checkNotNull((Object)defaultValue, (Object)"defaultValue");
    }
}

