/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud;

import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jclouds.predicates.validators.DnsNameValidator;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.MapPayloadParam;
import org.jclouds.rest.annotations.ParamValidators;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;
import org.jclouds.vcloud.CommonVCloudAsyncClient;
import org.jclouds.vcloud.binders.BindCloneVAppParamsToXmlPayload;
import org.jclouds.vcloud.binders.BindInstantiateVCloudExpressVAppTemplateParamsToXmlPayload;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.VCloudExpressVApp;
import org.jclouds.vcloud.domain.VCloudExpressVAppTemplate;
import org.jclouds.vcloud.domain.network.OrgNetwork;
import org.jclouds.vcloud.filters.SetVCloudTokenCookie;
import org.jclouds.vcloud.functions.OrgNameCatalogNameVAppTemplateNameToEndpoint;
import org.jclouds.vcloud.functions.OrgNameVDCNameResourceEntityNameToEndpoint;
import org.jclouds.vcloud.options.CloneVAppOptions;
import org.jclouds.vcloud.options.InstantiateVAppTemplateOptions;
import org.jclouds.vcloud.xml.OrgNetworkFromVCloudExpressNetworkHandler;
import org.jclouds.vcloud.xml.TaskHandler;
import org.jclouds.vcloud.xml.VCloudExpressVAppHandler;
import org.jclouds.vcloud.xml.VCloudExpressVAppTemplateHandler;

@RequestFilters(value={SetVCloudTokenCookie.class})
public interface VCloudExpressAsyncClient
extends CommonVCloudAsyncClient {
    @GET
    @Consumes(value={"application/vnd.vmware.vcloud.vAppTemplate+xml"})
    @XMLResponseParser(value=VCloudExpressVAppTemplateHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends VCloudExpressVAppTemplate> getVAppTemplate(@EndpointParam URI var1);

    @GET
    @Consumes(value={"application/vnd.vmware.vcloud.vAppTemplate+xml"})
    @XMLResponseParser(value=VCloudExpressVAppTemplateHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends VCloudExpressVAppTemplate> findVAppTemplateInOrgCatalogNamed(@Nullable @EndpointParam(parser=OrgNameCatalogNameVAppTemplateNameToEndpoint.class) String var1, @Nullable @EndpointParam(parser=OrgNameCatalogNameVAppTemplateNameToEndpoint.class) String var2, @EndpointParam(parser=OrgNameCatalogNameVAppTemplateNameToEndpoint.class) String var3);

    @GET
    @Consumes(value={"application/vnd.vmware.vcloud.network+xml"})
    @XMLResponseParser(value=OrgNetworkFromVCloudExpressNetworkHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends OrgNetwork> findNetworkInOrgVDCNamed(@Nullable @EndpointParam(parser=OrgNameVDCNameResourceEntityNameToEndpoint.class) String var1, @Nullable @EndpointParam(parser=OrgNameVDCNameResourceEntityNameToEndpoint.class) String var2, @EndpointParam(parser=OrgNameVDCNameResourceEntityNameToEndpoint.class) String var3);

    @GET
    @Consumes(value={"application/vnd.vmware.vcloud.network+xml"})
    @XMLResponseParser(value=OrgNetworkFromVCloudExpressNetworkHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends OrgNetwork> getNetwork(@EndpointParam URI var1);

    @POST
    @Path(value="/action/instantiateVAppTemplate")
    @Produces(value={"application/vnd.vmware.vcloud.instantiateVAppTemplateParams+xml"})
    @Consumes(value={"application/vnd.vmware.vcloud.vApp+xml"})
    @XMLResponseParser(value=VCloudExpressVAppHandler.class)
    @MapBinder(value=BindInstantiateVCloudExpressVAppTemplateParamsToXmlPayload.class)
    public ListenableFuture<? extends VCloudExpressVApp> instantiateVAppTemplateInVDC(@EndpointParam URI var1, @MapPayloadParam(value="template") URI var2, @MapPayloadParam(value="name") @ParamValidators(value={DnsNameValidator.class}) String var3, InstantiateVAppTemplateOptions ... var4);

    @POST
    @Path(value="/action/cloneVApp")
    @Produces(value={"application/vnd.vmware.vcloud.cloneVAppParams+xml"})
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @XMLResponseParser(value=TaskHandler.class)
    @MapBinder(value=BindCloneVAppParamsToXmlPayload.class)
    public ListenableFuture<? extends Task> cloneVAppInVDC(@EndpointParam URI var1, @MapPayloadParam(value="vApp") URI var2, @MapPayloadParam(value="newName") @ParamValidators(value={DnsNameValidator.class}) String var3, CloneVAppOptions ... var4);

    @GET
    @Consumes(value={"application/vnd.vmware.vcloud.vApp+xml"})
    @XMLResponseParser(value=VCloudExpressVAppHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends VCloudExpressVApp> findVAppInOrgVDCNamed(@Nullable @EndpointParam(parser=OrgNameVDCNameResourceEntityNameToEndpoint.class) String var1, @Nullable @EndpointParam(parser=OrgNameVDCNameResourceEntityNameToEndpoint.class) String var2, @EndpointParam(parser=OrgNameVDCNameResourceEntityNameToEndpoint.class) String var3);

    @GET
    @Consumes(value={"application/vnd.vmware.vcloud.vApp+xml"})
    @XMLResponseParser(value=VCloudExpressVAppHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends VCloudExpressVApp> getVApp(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Path(value="/action/deploy")
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<? extends Task> deployVApp(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Path(value="/action/undeploy")
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<? extends Task> undeployVApp(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Path(value="/power/action/powerOn")
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<? extends Task> powerOnVApp(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Path(value="/power/action/powerOff")
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<? extends Task> powerOffVApp(@EndpointParam URI var1);

    @POST
    @Path(value="/power/action/shutdown")
    public ListenableFuture<Void> shutdownVApp(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Path(value="/power/action/reset")
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<? extends Task> resetVApp(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Path(value="/power/action/suspend")
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<? extends Task> suspendVApp(@EndpointParam URI var1);

    @DELETE
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteVApp(@EndpointParam URI var1);
}

