/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.VCloudExpressVApp;
import org.jclouds.vcloud.domain.internal.VCloudExpressVAppImpl;
import org.jclouds.vcloud.domain.ovf.ResourceAllocation;
import org.jclouds.vcloud.domain.ovf.System;
import org.jclouds.vcloud.util.Utils;
import org.jclouds.vcloud.xml.ovf.ResourceAllocationHandler;
import org.jclouds.vcloud.xml.ovf.SystemHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VCloudExpressVAppHandler
extends ParseSax.HandlerWithResult<VCloudExpressVApp> {
    private final String apiVersion;
    private final SystemHandler systemHandler;
    private final ResourceAllocationHandler allocationHandler;
    @Resource
    protected Logger logger = Logger.NULL;
    protected System system;
    protected Set<ResourceAllocation> allocations = Sets.newLinkedHashSet();
    protected Status status;
    protected final ListMultimap<String, String> networkToAddresses = ArrayListMultimap.create();
    protected StringBuilder currentText = new StringBuilder();
    protected String operatingSystemDescription;
    protected boolean inOs;
    protected String networkName;
    protected String name;
    protected Integer osType;
    protected URI location;
    protected Long size;
    protected ReferenceType vDC;

    @Inject
    public VCloudExpressVAppHandler(@Named(value="jclouds.api-version") String apiVersion, SystemHandler systemHandler, ResourceAllocationHandler allocationHandler) {
        this.apiVersion = apiVersion;
        this.systemHandler = systemHandler;
        this.allocationHandler = allocationHandler;
    }

    public VCloudExpressVApp getResult() {
        return new VCloudExpressVAppImpl(this.name, this.location, this.status, this.size, this.vDC, this.networkToAddresses, this.osType, this.operatingSystemDescription, this.system, this.allocations);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map attributes = Utils.cleanseAttributes((Attributes)attrs);
        if (qName.equals("VApp")) {
            ReferenceType resource = Utils.newReferenceType((Map)attributes);
            this.name = resource.getName();
            this.location = resource.getHref();
            String statusString = (String)attributes.get("status");
            this.status = this.apiVersion.indexOf("0.8") != -1 && "2".equals(statusString) ? Status.OFF : Status.fromValue((String)statusString);
            if (attributes.containsKey("size")) {
                this.size = new Long((String)attributes.get("size"));
            }
        } else if (qName.equals("Link")) {
            if (attributes.containsKey("type") && ((String)attributes.get("type")).equals("application/vnd.vmware.vcloud.vdc+xml")) {
                this.vDC = Utils.newReferenceType((Map)attributes);
            }
        } else if (qName.equals("OperatingSystemSection")) {
            this.inOs = true;
            if (attributes.containsKey("id")) {
                this.osType = Integer.parseInt((String)attributes.get("id"));
            }
        } else if (qName.endsWith("NetworkConnection")) {
            this.networkName = (String)attributes.get("Network");
        } else {
            this.systemHandler.startElement(uri, localName, qName, attrs);
            this.allocationHandler.startElement(uri, localName, qName, attrs);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("OperatingSystemSection")) {
            this.inOs = false;
        } else if (this.inOs && qName.equals("Description")) {
            this.operatingSystemDescription = this.currentText.toString().trim();
        } else if (qName.endsWith("IpAddress")) {
            this.networkToAddresses.put((Object)this.networkName, (Object)this.currentText.toString().trim());
        } else if (qName.equals("System")) {
            this.systemHandler.endElement(uri, localName, qName);
            this.system = this.systemHandler.getResult();
        } else if (qName.equals("Item")) {
            this.allocationHandler.endElement(uri, localName, qName);
            this.allocations.add(this.allocationHandler.getResult());
        } else {
            this.systemHandler.endElement(uri, localName, qName);
            this.allocationHandler.endElement(uri, localName, qName);
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
        this.systemHandler.characters(ch, start, length);
        this.allocationHandler.characters(ch, start, length);
    }
}

