/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.VCloudExpressNetwork;
import org.jclouds.vcloud.domain.network.firewall.FirewallPolicy;
import org.jclouds.vcloud.domain.network.firewall.FirewallRule;
import org.jclouds.vcloud.domain.network.internal.VCloudExpressNetworkImpl;
import org.jclouds.vcloud.domain.network.nat.NatProtocol;
import org.jclouds.vcloud.domain.network.nat.rules.PortForwardingRule;
import org.jclouds.vcloud.util.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VCloudExpressNetworkHandler
extends ParseSax.HandlerWithResult<VCloudExpressNetwork> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected StringBuilder currentText = new StringBuilder();
    protected ReferenceType network;
    protected String description;
    protected Set<String> dnsServers = Sets.newLinkedHashSet();
    protected String gateway;
    protected String netmask;
    protected Set<FenceMode> fenceModes = Sets.newLinkedHashSet();
    protected Boolean dhcp;
    protected Set<PortForwardingRule> natRules = Sets.newLinkedHashSet();
    protected Set<FirewallRule> firewallRules = Sets.newLinkedHashSet();
    protected String externalIP;
    protected Integer externalPort;
    protected String internalIP;
    protected Integer internalPort;
    protected FirewallPolicy policy;
    protected String sourceIP;
    protected int sourcePort;

    public VCloudExpressNetwork getResult() {
        return new VCloudExpressNetworkImpl(this.network.getName(), this.network.getType(), this.network.getHref(), this.description, this.dnsServers, this.gateway, this.netmask, this.fenceModes, this.dhcp, this.natRules, this.firewallRules);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map attributes = Utils.cleanseAttributes((Attributes)attrs);
        if (qName.equals("Network")) {
            this.network = Utils.newReferenceType((Map)attributes);
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Description")) {
            this.description = this.currentOrNull();
        } else if (qName.equals("Dns")) {
            this.dnsServers.add(this.currentOrNull());
        } else if (qName.equals("Gateway")) {
            this.gateway = this.currentOrNull();
        } else if (qName.equals("Netmask")) {
            this.netmask = this.currentOrNull();
        } else if (qName.equals("FenceMode")) {
            try {
                this.fenceModes.add(FenceMode.fromValue((String)this.currentOrNull()));
            }
            catch (IllegalArgumentException e) {
                this.fenceModes.add(FenceMode.BRIDGED);
            }
        } else if (qName.equals("Dhcp")) {
            this.dhcp = new Boolean(this.currentOrNull());
        } else if (qName.equals("NatRule")) {
            this.natRules.add(new PortForwardingRule(this.externalIP, this.externalPort.intValue(), this.internalIP, this.internalPort.intValue(), NatProtocol.TCP_UDP));
            this.externalIP = null;
            this.externalPort = null;
            this.internalIP = null;
            this.internalPort = null;
        } else if (qName.equals("ExternalIP")) {
            this.externalIP = this.currentOrNull();
        } else if (qName.equals("ExternalPort")) {
            this.externalPort = Integer.parseInt(this.currentOrNull());
        } else if (qName.equals("InternalIP")) {
            this.internalIP = this.currentOrNull();
        } else if (qName.equals("InternalPort")) {
            this.internalPort = Integer.parseInt(this.currentOrNull());
        } else if (qName.equals("FirewallRule")) {
            this.firewallRules.add(new FirewallRule(true, null, this.policy, null, this.sourcePort, this.sourceIP));
            this.policy = null;
            this.sourceIP = null;
            this.sourcePort = -1;
        } else if (qName.equals("Policy")) {
            this.policy = FirewallPolicy.fromValue((String)this.currentOrNull());
        } else if (qName.equals("SourceIp")) {
            this.sourceIP = this.currentOrNull();
        } else if (qName.equals("SourcePort")) {
            this.sourcePort = Integer.parseInt(this.currentOrNull());
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }
}

