/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.VCloudExpressAsyncClient;
import org.jclouds.vcloud.domain.Catalog;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.ReferenceType;

@Singleton
public class VCloudExpressAllCatalogItemsInCatalog
implements Function<Catalog, Iterable<? extends CatalogItem>> {
    @Resource
    @Named(value="jclouds.compute")
    public Logger logger = Logger.NULL;
    private final VCloudExpressAsyncClient aclient;
    private final ExecutorService executor;

    @Inject
    VCloudExpressAllCatalogItemsInCatalog(VCloudExpressAsyncClient aclient, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.aclient = aclient;
        this.executor = executor;
    }

    public Iterable<? extends CatalogItem> apply(Catalog from) {
        Iterable catalogItems = FutureIterables.transformParallel((Iterable)Iterables.filter((Iterable)from.values(), (Predicate)new Predicate<ReferenceType>(){

            public boolean apply(ReferenceType input) {
                return input.getType().equals("application/vnd.vmware.vcloud.catalogItem+xml");
            }
        }), (Function)new Function<ReferenceType, Future<CatalogItem>>(){

            public Future<CatalogItem> apply(ReferenceType from) {
                return VCloudExpressAllCatalogItemsInCatalog.this.aclient.getCatalogItem(from.getHref());
            }
        }, (ExecutorService)this.executor, null, (Logger)this.logger, (String)("catalogItems in " + from.getHref()));
        return catalogItems;
    }
}

