/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import org.jclouds.vcloud.domain.network.DhcpService;
import org.jclouds.vcloud.domain.network.Features;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.FirewallService;
import org.jclouds.vcloud.domain.network.IpScope;
import org.jclouds.vcloud.domain.network.NatService;
import org.jclouds.vcloud.domain.network.OrgNetwork;
import org.jclouds.vcloud.domain.network.VCloudExpressNetwork;
import org.jclouds.vcloud.domain.network.internal.OrgNetworkImpl;

public class VCloudExpressOrgNetworkAdapter
extends OrgNetworkImpl {
    public VCloudExpressOrgNetworkAdapter(VCloudExpressNetwork in) {
        super(in.getName(), in.getType(), in.getHref(), null, in.getDescription(), (Iterable)ImmutableSet.of(), VCloudExpressOrgNetworkAdapter.parseConfiguration(in), null, (Iterable)ImmutableSet.of());
    }

    static OrgNetwork.Configuration parseConfiguration(VCloudExpressNetwork in) {
        String dns1 = in.getDnsServers().size() > 0 ? (String)Iterables.get(in.getDnsServers(), (int)0) : null;
        String dns2 = in.getDnsServers().size() > 1 ? (String)Iterables.get(in.getDnsServers(), (int)1) : null;
        String gateway = in.getGateway();
        String netmask = in.getNetmask();
        FenceMode mode = in.getFenceModes().size() > 0 ? (FenceMode)Iterables.get(in.getFenceModes(), (int)0) : FenceMode.BRIDGED;
        DhcpService dhcp = in.isDhcp() != null && in.isDhcp() != false ? new DhcpService(true, null, null, null) : null;
        NatService nat = in.getNatRules().size() > 0 ? new NatService(true, null, null, in.getNatRules()) : null;
        FirewallService firewall = in.getFirewallRules().size() > 0 ? new FirewallService(true, in.getFirewallRules()) : null;
        return new OrgNetworkImpl.ConfigurationImpl(new IpScope(true, gateway, netmask, dns1, dns2, null, (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of()), null, mode, new Features(dhcp, firewall, nat));
    }
}

