/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.RequiresHttp;
import org.jclouds.rest.AsyncClientFactory;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.suppliers.RetryOnTimeOutButNotOnAuthorizationExceptionSupplier;
import org.jclouds.vcloud.VCloudExpressAsyncClient;
import org.jclouds.vcloud.VCloudExpressClient;
import org.jclouds.vcloud.VCloudExpressLoginAsyncClient;
import org.jclouds.vcloud.config.CommonVCloudRestClientModule;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.VCloudExpressVAppTemplate;
import org.jclouds.vcloud.domain.VCloudSession;
import org.jclouds.vcloud.functions.VCloudExpressVAppTemplatesForCatalogItems;

@RequiresHttp
@ConfiguresRestClient
public abstract class BaseVCloudExpressRestClientModule<S extends VCloudExpressClient, A extends VCloudExpressAsyncClient>
extends CommonVCloudRestClientModule<S, A> {
    public BaseVCloudExpressRestClientModule(Class<S> syncClientType, Class<A> asyncClientType) {
        super(syncClientType, asyncClientType);
    }

    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Function<Iterable<? extends CatalogItem>, Iterable<? extends VCloudExpressVAppTemplate>>>(){}).to((TypeLiteral)new TypeLiteral<VCloudExpressVAppTemplatesForCatalogItems>(){});
        super.configure();
    }

    @Provides
    @Singleton
    protected VCloudExpressLoginAsyncClient provideVCloudLogin(AsyncClientFactory factory) {
        return (VCloudExpressLoginAsyncClient)factory.create(VCloudExpressLoginAsyncClient.class);
    }

    @Provides
    @Singleton
    protected Supplier<VCloudSession> provideVCloudTokenCache(@Named(value="jclouds.session-interval") long seconds, final VCloudExpressLoginAsyncClient login) {
        return new RetryOnTimeOutButNotOnAuthorizationExceptionSupplier(this.authException, seconds, (Supplier)new Supplier<VCloudSession>(){

            public VCloudSession get() {
                try {
                    return (VCloudSession)login.login().get(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    Throwables.propagate((Throwable)e);
                    assert (false) : e;
                    return null;
                }
            }
        });
    }
}

