/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.vcloud.VCloudExpressClient;
import org.jclouds.vcloud.domain.VCloudExpressVApp;

@Singleton
public class VCloudExpressGetNodeMetadataStrategy
implements GetNodeMetadataStrategy {
    protected final VCloudExpressClient client;
    protected final Function<VCloudExpressVApp, NodeMetadata> vAppToNodeMetadata;

    @Inject
    protected VCloudExpressGetNodeMetadataStrategy(VCloudExpressClient client, Function<VCloudExpressVApp, NodeMetadata> vAppToNodeMetadata) {
        this.client = (VCloudExpressClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.vAppToNodeMetadata = vAppToNodeMetadata;
    }

    public NodeMetadata getNode(String in) {
        URI id = URI.create(in);
        VCloudExpressVApp from = this.client.getVApp(id);
        if (from == null) {
            return null;
        }
        return (NodeMetadata)this.vAppToNodeMetadata.apply((Object)from);
    }
}

