/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.strategy;

import com.google.common.base.Function;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.vcloud.VCloudExpressClient;
import org.jclouds.vcloud.compute.VCloudExpressComputeClient;
import org.jclouds.vcloud.domain.VCloudExpressVApp;
import org.jclouds.vcloud.options.InstantiateVAppTemplateOptions;

@Singleton
public class StartVAppWithGroupEncodedIntoName
implements CreateNodeWithGroupEncodedIntoName {
    protected final VCloudExpressClient client;
    protected final VCloudExpressComputeClient computeClient;
    protected final Function<VCloudExpressVApp, NodeMetadata> vAppToNodeMetadata;

    @Inject
    protected StartVAppWithGroupEncodedIntoName(VCloudExpressClient client, VCloudExpressComputeClient computeClient, Function<VCloudExpressVApp, NodeMetadata> vAppToNodeMetadata) {
        this.client = client;
        this.computeClient = computeClient;
        this.vAppToNodeMetadata = vAppToNodeMetadata;
    }

    public NodeMetadata createNodeWithGroupEncodedIntoName(String tag, String name, Template template) {
        InstantiateVAppTemplateOptions options = InstantiateVAppTemplateOptions.Builder.processorCount((int)((int)ComputeServiceUtils.getCores((Hardware)template.getHardware()))).memory((long)template.getHardware().getRam()).disk((long)(((Volume)template.getHardware().getVolumes().get(0)).getSize().floatValue() * 1024.0f * 1024.0f));
        if (!template.getOptions().shouldBlockUntilRunning()) {
            options.block(false);
        }
        VCloudExpressVApp vApp = this.computeClient.start(URI.create(template.getLocation().getId()), URI.create(template.getImage().getId()), name, options, template.getOptions().getInboundPorts());
        return (NodeMetadata)this.vAppToNodeMetadata.apply((Object)vApp);
    }
}

