/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.os.CIMOperatingSystem;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.vcloud.compute.VCloudExpressComputeClient;
import org.jclouds.vcloud.compute.functions.FindLocationForResource;
import org.jclouds.vcloud.compute.functions.HardwareForVCloudExpressVApp;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.VCloudExpressVApp;

@Singleton
public class VCloudExpressVAppToNodeMetadata
implements Function<VCloudExpressVApp, NodeMetadata> {
    protected final VCloudExpressComputeClient computeClient;
    protected final Map<String, Credentials> credentialStore;
    protected final Supplier<Set<? extends Image>> images;
    protected final FindLocationForResource findLocationForResourceInVDC;
    protected final HardwareForVCloudExpressVApp hardwareForVCloudExpressVApp;
    protected final Map<Status, NodeState> vAppStatusToNodeState;

    @Inject
    protected VCloudExpressVAppToNodeMetadata(VCloudExpressComputeClient computeClient, Map<String, Credentials> credentialStore, Map<Status, NodeState> vAppStatusToNodeState, HardwareForVCloudExpressVApp hardwareForVCloudExpressVApp, FindLocationForResource findLocationForResourceInVDC, @Memoized Supplier<Set<? extends Image>> images) {
        this.images = (Supplier)Preconditions.checkNotNull(images, (Object)"images");
        this.hardwareForVCloudExpressVApp = (HardwareForVCloudExpressVApp)Preconditions.checkNotNull((Object)hardwareForVCloudExpressVApp, (Object)"hardwareForVCloudExpressVApp");
        this.findLocationForResourceInVDC = (FindLocationForResource)Preconditions.checkNotNull((Object)findLocationForResourceInVDC, (Object)"findLocationForResourceInVDC");
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
        this.computeClient = (VCloudExpressComputeClient)Preconditions.checkNotNull((Object)computeClient, (Object)"computeClient");
        this.vAppStatusToNodeState = (Map)Preconditions.checkNotNull(vAppStatusToNodeState, (Object)"vAppStatusToNodeState");
    }

    public NodeMetadata apply(VCloudExpressVApp from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getHref().toASCIIString());
        builder.uri(from.getHref());
        builder.name(from.getName());
        builder.location(this.findLocationForResourceInVDC.apply(from.getVDC()));
        builder.group(ComputeServiceUtils.parseGroupFromName((String)from.getName()));
        builder.operatingSystem((OperatingSystem)(from.getOsType() != null ? new CIMOperatingSystem(CIMOperatingSystem.OSType.fromValue((int)from.getOsType()), null, null, from.getOperatingSystemDescription()) : null));
        builder.hardware(this.hardwareForVCloudExpressVApp.apply(from));
        builder.state(this.vAppStatusToNodeState.get(from.getStatus()));
        builder.publicAddresses((Iterable)this.computeClient.getPublicAddresses(from.getHref()));
        builder.privateAddresses((Iterable)this.computeClient.getPrivateAddresses(from.getHref()));
        builder.credentials(this.credentialStore.get("node#" + from.getHref().toASCIIString()));
        return builder.build();
    }
}

