/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.vcloud.domain.ovf.ResourceAllocation;
import org.jclouds.vcloud.domain.ovf.ResourceType;
import org.jclouds.vcloud.predicates.VCloudPredicates;

@Singleton
public class ResourceAllocationsToVolumes
implements Function<Iterable<? extends ResourceAllocation>, Iterable<Volume>> {
    public Iterable<Volume> apply(Iterable<? extends ResourceAllocation> resourceAllocations) {
        Iterable volumes = Iterables.transform((Iterable)Iterables.filter(resourceAllocations, (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.DISK_DRIVE)), (Function)new Function<ResourceAllocation, Volume>(){

            public Volume apply(ResourceAllocation from) {
                return new VolumeImpl(from.getAddressOnParent() + "", Volume.Type.LOCAL, Float.valueOf((float)(from.getVirtualQuantity() / 1024L) / 1024.0f), null, from.getAddressOnParent() == 0, true);
            }
        });
        return volumes;
    }
}

