/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.vcloud.compute.functions.ImageForVCloudExpressVAppTemplate;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VCloudExpressVAppTemplate;
import org.jclouds.vcloud.domain.VDC;
import org.jclouds.vcloud.functions.VCloudExpressVAppTemplatesForResourceEntities;

@Singleton
public class ImagesInVCloudExpressVDC
implements Function<VDC, Iterable<? extends Image>> {
    private final VCloudExpressVAppTemplatesForResourceEntities vAppTemplatesForResourceEntities;
    private final ImageForVCloudExpressVAppTemplate imageForVAppTemplateProvider;

    @Inject
    public ImagesInVCloudExpressVDC(VCloudExpressVAppTemplatesForResourceEntities vAppTemplatesForResourceEntities, ImageForVCloudExpressVAppTemplate imageForVAppTemplateProvider) {
        this.vAppTemplatesForResourceEntities = (VCloudExpressVAppTemplatesForResourceEntities)Preconditions.checkNotNull((Object)vAppTemplatesForResourceEntities, (Object)"vAppTemplatesForResourceEntities");
        this.imageForVAppTemplateProvider = (ImageForVCloudExpressVAppTemplate)Preconditions.checkNotNull((Object)imageForVAppTemplateProvider, (Object)"imageForVAppTemplateProvider");
    }

    public Iterable<? extends Image> apply(VDC from) {
        Iterable<? extends VCloudExpressVAppTemplate> vAppTemplates = this.vAppTemplatesForResourceEntities.apply(((VDC)Preconditions.checkNotNull((Object)from, (Object)"vdc")).getResourceEntities().values());
        return Iterables.transform(vAppTemplates, (Function)this.imageForVAppTemplateProvider.withParent((ReferenceType)from));
    }
}

