/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.vcloud.compute.functions.ImageForVCloudExpressVAppTemplate;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VCloudExpressVAppTemplate;
import org.jclouds.vcloud.functions.AllCatalogItemsInOrg;

@Singleton
public class ImagesInVCloudExpressOrg
implements Function<Org, Iterable<? extends Image>> {
    private final AllCatalogItemsInOrg allCatalogItemsInOrg;
    private final Function<Iterable<? extends CatalogItem>, Iterable<? extends VCloudExpressVAppTemplate>> vAppTemplatesForCatalogItems;
    private final Provider<ImageForVCloudExpressVAppTemplate> imageForVAppTemplateProvider;

    @Inject
    ImagesInVCloudExpressOrg(AllCatalogItemsInOrg allCatalogItemsInOrg, Provider<ImageForVCloudExpressVAppTemplate> imageForVAppTemplateProvider, Function<Iterable<? extends CatalogItem>, Iterable<? extends VCloudExpressVAppTemplate>> vAppTemplatesForCatalogItems) {
        this.imageForVAppTemplateProvider = imageForVAppTemplateProvider;
        this.allCatalogItemsInOrg = allCatalogItemsInOrg;
        this.vAppTemplatesForCatalogItems = vAppTemplatesForCatalogItems;
    }

    public Iterable<? extends Image> apply(Org from) {
        Iterable catalogs = this.allCatalogItemsInOrg.apply(from);
        Iterable vAppTemplates = (Iterable)this.vAppTemplatesForCatalogItems.apply((Object)catalogs);
        return Iterables.transform((Iterable)vAppTemplates, (Function)((ImageForVCloudExpressVAppTemplate)this.imageForVAppTemplateProvider.get()).withParent((ReferenceType)from));
    }
}

