/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.io.Payload;
import org.jclouds.openstack.swift.blobstore.functions.ResourceToObjectInfo;
import org.jclouds.openstack.swift.domain.SwiftObject;

@Singleton
public class BlobToObject
implements Function<Blob, SwiftObject> {
    private final ResourceToObjectInfo blob2ObjectMd;
    private final SwiftObject.Factory objectProvider;

    @Inject
    BlobToObject(ResourceToObjectInfo blob2ObjectMd, SwiftObject.Factory objectProvider) {
        this.blob2ObjectMd = blob2ObjectMd;
        this.objectProvider = objectProvider;
    }

    public SwiftObject apply(Blob from) {
        if (from == null) {
            return null;
        }
        SwiftObject object = this.objectProvider.create(this.blob2ObjectMd.apply((StorageMetadata)from.getMetadata()));
        object.setPayload((Payload)Preconditions.checkNotNull((Object)from.getPayload(), (Object)("payload: " + from)));
        object.setAllHeaders((Multimap<String, String>)from.getAllHeaders());
        return object;
    }
}

