/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.date.TimeStamp;
import org.jclouds.openstack.swift.CommonSwiftAsyncClient;
import org.jclouds.openstack.swift.SwiftAsyncClient;
import org.jclouds.openstack.swift.SwiftKeystoneAsyncClient;
import org.jclouds.openstack.swift.TemporaryUrlKey;
import org.jclouds.openstack.swift.blobstore.SwiftBlobSigner;
import org.jclouds.openstack.swift.extensions.KeystoneTemporaryUrlKeyAsyncApi;
import org.jclouds.openstack.swift.extensions.TemporaryUrlKeyApi;
import org.jclouds.openstack.swift.extensions.TemporaryUrlKeyAsyncApi;
import org.jclouds.openstack.swift.suppliers.ReturnOrFetchTemporaryUrlKey;
import org.jclouds.rest.config.BinderUtils;

public abstract class TemporaryUrlExtensionModule<A extends CommonSwiftAsyncClient>
extends AbstractModule {
    @Provides
    @TimeStamp
    protected Long unixEpochTimestampProvider() {
        return System.currentTimeMillis() / 1000L;
    }

    protected void configure() {
        this.bindRequestSigner();
        this.bindTemporaryUrlKeyApi();
        this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).annotatedWith(TemporaryUrlKey.class).to(ReturnOrFetchTemporaryUrlKeyMemoized.class);
    }

    protected abstract void bindRequestSigner();

    protected void bindTemporaryUrlKeyApi() {
        BinderUtils.bindSyncToAsyncHttpApi((Binder)this.binder(), TemporaryUrlKeyApi.class, TemporaryUrlKeyAsyncApi.class);
    }

    @Singleton
    private static class ReturnOrFetchTemporaryUrlKeyMemoized
    implements Supplier<String> {
        private final Supplier<String> delegate;

        @Inject
        private ReturnOrFetchTemporaryUrlKeyMemoized(TemporaryUrlKeyApi client, @Named(value="jclouds.session-interval") long sessionInterval) {
            this.delegate = Suppliers.memoizeWithExpiration((Supplier)new ReturnOrFetchTemporaryUrlKey(client), (long)sessionInterval, (TimeUnit)TimeUnit.SECONDS);
        }

        public String get() {
            return (String)this.delegate.get();
        }
    }

    public static class SwiftKeystoneTemporaryUrlExtensionModule
    extends TemporaryUrlExtensionModule<SwiftKeystoneAsyncClient> {
        @Override
        protected void bindTemporaryUrlKeyApi() {
            BinderUtils.bindSyncToAsyncHttpApi((Binder)this.binder(), TemporaryUrlKeyApi.class, KeystoneTemporaryUrlKeyAsyncApi.class);
        }

        @Override
        protected void bindRequestSigner() {
            this.bind(BlobRequestSigner.class).to((TypeLiteral)new TypeLiteral<SwiftBlobSigner<SwiftKeystoneAsyncClient>>(){});
        }
    }

    public static class SwiftTemporaryUrlExtensionModule
    extends TemporaryUrlExtensionModule<SwiftAsyncClient> {
        @Override
        protected void bindRequestSigner() {
            this.bind(BlobRequestSigner.class).to((TypeLiteral)new TypeLiteral<SwiftBlobSigner<SwiftAsyncClient>>(){});
        }
    }
}

