/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore.integration;

import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.integration.internal.BaseBlobIntegrationTest;
import org.jclouds.blobstore.options.PutOptions;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class SwiftBlobIntegrationLiveTest
extends BaseBlobIntegrationTest {
    private InputSupplier<InputStream> oneHundredOneConstitutions;
    private byte[] oneHundredOneConstitutionsMD5;

    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        this.setIfTestSystemPropertyPresent(props, "jclouds.keystone.credential-type");
        return props;
    }

    public SwiftBlobIntegrationLiveTest() {
        this.provider = System.getProperty("test.swift.provider", "swift");
    }

    @Test(enabled=false)
    public void testGetTwoRanges() {
    }

    @BeforeClass(groups={"integration", "live"}, dependsOnMethods={"setupContext"})
    public void setUpResourcesOnThisThread(ITestContext testContext) throws Exception {
        super.setUpResourcesOnThisThread(testContext);
        this.oneHundredOneConstitutions = SwiftBlobIntegrationLiveTest.getTestDataSupplier();
        this.oneHundredOneConstitutionsMD5 = SwiftBlobIntegrationLiveTest.md5Supplier(this.oneHundredOneConstitutions);
    }

    protected void checkContentDisposition(Blob blob, String contentDisposition) {
        super.checkContentDisposition(blob, contentDisposition);
    }

    protected void checkContentLanguage(Blob blob, String contentLanguage) {
        assert (blob.getPayload().getContentMetadata().getContentLanguage() == null);
        assert (blob.getMetadata().getContentMetadata().getContentLanguage() == null);
    }

    @DataProvider(name="delete")
    public Object[][] createData() {
        return new Object[][]{{"normal"}, {"sp ace"}, {"qu?stion"}, {"unic\u20aade"}, {"path/foo"}, {"colon:"}, {"asteri*k"}, {"{great<r}"}, {"lesst>en"}, {"p|pe"}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipartChunkedFileStream() throws IOException, InterruptedException {
        Files.copy(this.oneHundredOneConstitutions, (File)new File("target/const.txt"));
        String containerName = this.getContainerName();
        try {
            BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
            blobStore.createContainerInLocation(null, containerName);
            Blob blob = blobStore.blobBuilder("const.txt").payload(new File("target/const.txt")).contentMD5(this.oneHundredOneConstitutionsMD5).build();
            blobStore.putBlob(containerName, blob, PutOptions.Builder.multipart());
        }
        finally {
            this.returnContainer(containerName);
        }
    }
}

