/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.binders;

import com.google.common.collect.ImmutableList;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.swift.CommonSwiftClientTest;
import org.jclouds.openstack.swift.binders.BindIterableToHeadersWithContainerDeleteMetadataPrefix;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BindListToHeadersWithContainerDeleteMetadataPrefixTest")
public class BindMapToHeadersWithContainerMetadataPrefixTest
extends CommonSwiftClientTest {
    @Test
    public void testMetadataKeysBind() {
        ImmutableList metadataKeys = ImmutableList.of((Object)"foo", (Object)"bar");
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint("http://localhost").build();
        BindIterableToHeadersWithContainerDeleteMetadataPrefix binder = (BindIterableToHeadersWithContainerDeleteMetadataPrefix)this.injector.getInstance(BindIterableToHeadersWithContainerDeleteMetadataPrefix.class);
        HttpRequest actualRequest = binder.bindToRequest(request, (Object)metadataKeys);
        HttpRequest expectedRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("http://localhost").addHeader("X-Remove-Container-Meta-foo", new String[]{""})).addHeader("X-Remove-Container-Meta-bar", new String[]{""})).build();
        Assert.assertEquals((Object)actualRequest, (Object)expectedRequest);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullListIsBad() {
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint("http://localhost").build();
        BindIterableToHeadersWithContainerDeleteMetadataPrefix binder = (BindIterableToHeadersWithContainerDeleteMetadataPrefix)this.injector.getInstance(BindIterableToHeadersWithContainerDeleteMetadataPrefix.class);
        binder.bindToRequest(request, null);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullRequestIsBad() {
        ImmutableList metadataKeys = ImmutableList.of((Object)"foo", (Object)"bar");
        BindIterableToHeadersWithContainerDeleteMetadataPrefix binder = (BindIterableToHeadersWithContainerDeleteMetadataPrefix)this.injector.getInstance(BindIterableToHeadersWithContainerDeleteMetadataPrefix.class);
        binder.bindToRequest(null, (Object)metadataKeys);
    }
}

